package ru.yandex.direct.core.entity.postviewofflinereport

import ru.yandex.direct.core.entity.postviewofflinereport.model.PostviewOfflineReport
import ru.yandex.direct.core.entity.postviewofflinereport.model.PostviewOfflineReportJobParams
import ru.yandex.direct.core.entity.postviewofflinereport.model.PostviewOfflineReportJobResult
import ru.yandex.direct.dbqueue.model.DbQueueJob

class PostviewOfflineReportConverter {
    companion object {
        @JvmStatic
        fun convertJobToReport(job: DbQueueJob<PostviewOfflineReportJobParams, PostviewOfflineReportJobResult>): PostviewOfflineReport {
            return PostviewOfflineReport(
                clientId = job.clientId,
                id = job.id,
                campaignIds = job.args.campaignIds,
                dateFrom = job.args.dateFrom,
                dateTo = job.args.dateTo,
                status = job.status,
                createTime = job.creationTime,
                finishTime = job.grabbedAt,
                url = job.result?.reportUrl,
                error = job.result?.error
            )
        }
    }
}
