package ru.yandex.direct.core.entity.postviewofflinereport.model

enum class PostViewOfflineReportDeviceType(val devicePublicType: String) {
    DESKTOPS("Десктопы"),
    SMARTPHONES("Смартфоны"),
    TABLETS("Планшеты"),
    ;

    companion object {
        private val lookup = values().associateBy(PostViewOfflineReportDeviceType::devicePublicType)

        fun fromValue(devicePublicType: String) : PostViewOfflineReportDeviceType {
            return requireNotNull(lookup[devicePublicType]) { "Unknown device type $devicePublicType" }
        }
    }
}
