package ru.yandex.direct.core.entity.postviewofflinereport.model

import java.time.LocalDate

data class PostViewOfflineReportRow(
    val clicks: Long,
    val shows: Long,
    val cost: Double,
    val date: LocalDate,
    val visits: Long,
    val bounce: Long,
    val convertedSession: Long,
    val deviceType: PostViewOfflineReportDeviceType,
    // поля, не меняющиеся от строки к строке, общие на весь отчёт:
    val campaigns: List<Long>,
    val start: LocalDate, // начало периода отчёта
    val end: LocalDate, // конец периода отчёта
    val goals: String, // номера целей через запятую или "Ecom"
    val postponedPeriod: Int, // отложенный период в днях
    // также в конечном отчёте есть валюта, её нужно достать из базы
)
