package ru.yandex.direct.core.entity.postviewofflinereport.model;

import java.time.LocalDate;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

@ParametersAreNonnullByDefault
public class PostViewOfflineReportYtRow extends YtTableRow {
    public static final YtField<Long> CLICKS = new YtField<>("Clicks", Long.class);

    public static final YtField<Double> COST = new YtField<>("Cost", Double.class);

    public static final YtField<String> DATE = new YtField<>("Date", String.class);

    public static final YtField<Integer> POSTPONED_PERIOD = new YtField<>("Postponed_period", Integer.class);

    public static final YtField<Long> SHOWS = new YtField<>("Shows", Long.class);

    public static final YtField<Long> VISITS = new YtField<>("Visits", Long.class);

    public static final YtField<Long> BOUNCE = new YtField<>("bounce", Long.class);

    public static final YtField<String> CAMPAIGN = new YtField<>("campaign", String.class);

    public static final YtField<Long> CONVERTED_SESSION = new YtField<>("converted_session", Long.class);

    public static final YtField<String> DEVICE_TYPE = new YtField<>("device_type", String.class);

    public static final YtField<String> END = new YtField<>("end", String.class);

    public static final YtField<String> GOALS = new YtField<>("goals", String.class);

    public static final YtField<String> START = new YtField<>("start", String.class);

    public PostViewOfflineReportYtRow() {
        super(List.of(CLICKS, COST, DATE, POSTPONED_PERIOD, SHOWS, VISITS, BOUNCE, CAMPAIGN, CONVERTED_SESSION,
                DEVICE_TYPE, END, GOALS, START));
    }

    public Long getClicks() {
        return valueOf(CLICKS);
    }

    public Double getCost() {
        return valueOf(COST);
    }

    public LocalDate getDate() {
        return LocalDate.parse(valueOf(DATE));
    }

    public Integer getPostponedPeriod() {
        return valueOf(POSTPONED_PERIOD);
    }

    public Long getShows() {
        return valueOf(SHOWS);
    }

    public Long getVisits() {
        return valueOf(VISITS);
    }

    public Long getBounce() {
        return valueOf(BOUNCE);
    }

    public String getCampaign() {
        return valueOf(CAMPAIGN);
    }

    public Long getConvertedSession() {
        return valueOf(CONVERTED_SESSION);
    }

    public String getDeviceType() {
        return valueOf(DEVICE_TYPE);
    }

    public LocalDate getEnd() {
        return LocalDate.parse(valueOf(END));
    }

    public String getGoals() {
        return valueOf(GOALS);
    }

    public LocalDate getStart() {
        return LocalDate.parse(valueOf(START));
    }
}
