package ru.yandex.direct.core.entity.postviewofflinereport.model

import ru.yandex.direct.dbqueue.model.DbQueueJobStatus
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDate
import java.time.LocalDateTime

data class PostviewOfflineReport(
    val clientId: ClientId,
    val id: Long,
    val campaignIds: Set<Long>,
    val dateFrom: LocalDate,
    val dateTo: LocalDate,
    val status: DbQueueJobStatus,
    val createTime: LocalDateTime,
    val finishTime: LocalDateTime?,
    val url: String?,
    val error: String?,
) {
    fun isDeletable(): Boolean {
        return status in (setOf(DbQueueJobStatus.FAILED, DbQueueJobStatus.FINISHED, DbQueueJobStatus.REVOKED))
    }
}
