package ru.yandex.direct.core.entity.postviewofflinereport.model


import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
class PostviewOfflineReportJobResult(
    val reportUrl: String?,
    val error: String?,
) {
    fun error(stacktrace: String?): PostviewOfflineReportJobResult {
        return PostviewOfflineReportJobResult(null, stacktrace)
    }

    fun success(reportUrl: String?): PostviewOfflineReportJobResult {
        return PostviewOfflineReportJobResult(reportUrl, null)
    }
}
