package ru.yandex.direct.core.entity.postviewofflinereport.validation

import java.time.LocalDate

class PostviewOfflineReportConstraints {
    companion object {
        const val MAX_PROCESSING_REPORTS_COUNT = 3
        const val MAX_DAYS_BEFORE_TODAY = 92L
        const val MIN_DAYS_BEFORE_TODAY = 2L
        @JvmStatic
        fun isValidDate(date: LocalDate): Boolean {
            return date.isAfter(LocalDate.now().minusDays(MAX_DAYS_BEFORE_TODAY + 1L))
                && date.isBefore(LocalDate.now().minusDays(MIN_DAYS_BEFORE_TODAY - 1L))
        }
    }
}
