package ru.yandex.direct.core.entity.ppcproperty.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.common.db.PpcPropertiesSupport.NAME_MAX_LENGTH;

/**
 * Список используемых в коде пропертей из ppcdict.ppc_properties.
 * Предпочтительнее использовать типизированные свойства из {@link ru.yandex.direct.common.db.PpcPropertyNames}
 */
@ParametersAreNonnullByDefault
public enum PpcPropertyEnum {
    /**
     * Забирать события переключения статусов url-мониторинга доменов из LB.
     * Забирать стейт url-мониторинга доменов из YT.
     */
    URL_MONITORING_ON_LB_AND_YT_ENABLED("url_monitoring_on_lb_and_yt_enabled"),
    /**
     * Максимальное время ожидания событий url-мониторинга из LB
     * Должно быть меньше интервала запуска UrlMonitoringEventReceivingJob
     */
    URL_MONITORING_EVENTS_READ_TIMEOUT_SECONDS("url_monitoring_events_read_timeout_seconds"),
    /**
     * Вычитывать события url-мониторинга из LB, но не рассылать нотификации
     */
    URL_MONITORING_ON_LB_DRY_RUN("url_monitoring_on_lb_dry_run"),
    AUTO_OVERDRAFT_MIN_VALUE("AUTOOVERDRAFT_MIN_VALUE"),
    USE_MODERATE_JSONRPC_PROXY_URL("use_moderate_jsonrpc_proxy_url"),
    SHOW_BELARUS_OLD_RUB_WARNING("show_belarus_old_rub_warning"),
    ADFOX_INPUT_ERR_REVIEWED("adfox.input.err.reviewed"),
    USE_JAVA_VCARDS_IN_SMART("use_java_vcards_in_smart"),
    USE_JAVA_VCARDS_FOR_MANAGE_VCARDS("use_java_vcards_for_mv"),
    OTHER_BANNERS_IN_MANAGE_VCARDS_PROPERTY_NAME("other_banners_in_mv"),
    DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS("DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS"),
    DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER("DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER"),
    AUCTION_PROBABILITY_TOTAL_CLICKS_MEANINGFULL_DIGITS_NUMBER(
            "AUCTIONPROBABILITY_TOTAL_CLICKS_MEANINGFULL_DIGITS_NUMBER"),
    AUCTION_PROBABILITY_MIN_TOTAL_CLICKS_TO_SHOW("AUCTIONPROBABILITY_MIN_TOTAL_CLICKS_TO_SHOW"),
    UNIFIED_TURBOLANDINGS("UNIFIED_TURBOLANDINGS"),
    USE_JAVA_BIDMODIFIERS_IN_CAMPAIGN("use_java_bidmodifiers_in_campaign"),
    BS_UPDATE_PLACEMENTS_OFFSET("bs.update.placements.offset"),
    ENABLE_EXPORT_FREELANCERS_PROJECTS_TO_YT("enable_export_freelancers_projects_to_yt"),
    DSS_CERTIFICATE_SERIAL_NUMBER("dss_certificate_serial_number"),
    ENABLE_IMPORT_FREELANCERS_RATING("enable_import_freelancers_rating"),
    USE_JAVA_UPDATE_COUNTER_GRANTS("use_java_update_counter_grants"),
    /**
    * Включение fallback режима для пинкодницы
    **/
    ENABLE_LIMITED_SUPPORT_READ_ALL_CLIENTS("enable_limited_support_read_all_clients"),
    /**
     * Информация о том, кто, когда и почему включил fallback режим.
     * Пример значения:
     * {"enabled_from": "2020-11-07", "reason_type": "manual", "reason_text": "Idm delay 71s > 60s (threshold)",
     * "solomon_link": "https://solomon.yandex-team.ru/?project=direct&graph=idm_requests", "enabled_by": "someone's_login"}
     **/
    ENABLE_LIMITED_SUPPORT_READ_ALL_CLIENTS_META("enable_limited_support_read_all_clients_meta"),
    /**
     * С какими кластерами динтаблиц разрешено выполнять джобу RecommendationsMergeJob. Список строк в json.
     * Пример значения:
     * ["SENECA_MAN", "SENECA_SAS", "SENECA_VLA"]
     */
    JOBS_RECOMMENDATIONS_MERGE_ENABLED_ON_CLUSTERS("JOBS_RECOMMENDATIONS_MERGE_ENABLED_ON_CLUSTERS"),
    /**
     * С какими кластерами динтаблиц разрешено выполнять джобу UpdateAndTransferRecommendationsYtTableJob. Список
     * строк в json.
     * Пример значения:
     * ["SENECA_MAN", "SENECA_SAS", "SENECA_VLA"]
     */
    JOBS_RECOMMENDATIONS_TRANSFER_ENABLED_ON_CLUSTERS("JOBS_RECOMMENDATIONS_TRANSFER_ENABLED_ON_CLUSTERS"),
    /**
     * Для каждого типа рекомендации определяет, какой из источников нужно использовать. Map в json.
     * Пример значения:
     * {"1": "hahn", "2": "hahn", "3": "hahn", "4": "hahn", "5": "hahn", "6": "hahn", "7": "hahn"}
     */
    JOBS_RECOMMENDATIONS_MERGE_SOURCES_TO_USE("JOBS_RECOMMENDATIONS_MERGE_SOURCES_TO_USE"),
    /**
     * Таймаут в минутах для выполнения MapReduce-операции. Пример значения:
     * 15
     */
    JOBS_RECOMMENDATIONS_MERGE_MR_OPERATION_TIMEOUT("JOBS_RECOMMENDATIONS_MERGE_MR_OPERATION_TIMEOUT"),
    /**
     * Список типов рекомендаций, обработчики для которых будут вызываться recom-tracer'ом ("следилкой").
     * Обработчики для остальных типов вызываться не будут.
     * Пример значения:
     * [1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
     * <p>
     * TODO перейти на {@link ru.yandex.direct.common.db.PpcPropertyNames#RECOMMENDATIONS_TRACER_ENABLED_TYPES}
     * или выпилить его
     */
    RECOMMENDATIONS_TRACER_ENABLED_TYPES("RECOMMENDATIONS_TRACER_ENABLED_TYPES"),
    /**
     * Максимальное кол-во рекомендаций одного типа для клиента.
     * Пример значения: 100
     */
    RECOMMENDATIONS_MAX_ROW_COUNT_FOR_CLIENT("RECOMMENDATIONS_MAX_ROW_COUNT_FOR_CLIENT"),
    /**
     * Флаг для включание/отключения выгрузки по доменам для рассчета балансом комиссии по доменам.
     */
    EXPORT_BILLING_ORDER_DOMAIN_ENABLED("EXPORT_BILLING_ORDER_DOMAIN_ENABLED"),
    /**
     * Флаг для включания/отключения джобы контроля использования БОИДов в продуктах (сверки по БОИДам).
     * По умолчанию 0.
     */
    BOID_CHECK_MONITORING_ENABLED("BOID_CHECK_MONITORING_ENABLED"),
    /**
     * Флаг -- писать ли в Стартрек алерты от мониторинга по БОИДам.
     * По умолчанию 0.
     */
    BOID_CHECK_MONITORING_USE_TRACKER("BOID_CHECK_MONITORING_USE_TRACKER"),
    /**
     * Состояние предыдущего запуска джобы сверки боидов (JSON).
     */
    BOID_CHECK_MONITORING_STATE("BOID_CHECK_MONITORING_STATE"),
    /**
     * Флаг для включание/отключения генерации справочника по доменам (ClusterDomain) для рассчета балансом комиссии
     * по доменам.
     */
    EXPORT_CLUSTER_DOMAIN_ENABLED("EXPORT_CLUSTER_DOMAIN_ENABLED"),
    /**
     * Процент ТГО/РМП баннеров, которым можно отправлять картинку в ресурсах.
     * Приходит на замену дочерним баннерам-картинкам
     */
    ENABLE_BANNER_IMAGE_RESOURCES_PCT("ENABLE_BANNER_IMAGE_RESOURCES_PCT"),
    /**
     * Данные для отображения аварийной плашки в новом интерфейсе
     */
    NEW_INTERFACE_ALERT_ENABLED("NEW_INTERFACE_ALERT_ENABLED"),
    NEW_INTERFACE_ALERT_TEXT_RU("NEW_INTERFACE_ALERT_TEXT_RU"),
    NEW_INTERFACE_ALERT_TEXT_EN("NEW_INTERFACE_ALERT_TEXT_EN"),
    NEW_INTERFACE_ALERT_TEXT_CLIENT_IDS("NEW_INTERFACE_ALERT_TEXT_CLIENT_IDS"),
    /**
     * Флаг для загрузки статических файлов dna с S3
     */
    LOAD_DNA_FROM_S3("LOAD_DNA_FROM_S3"),

    /**
     * Кнопка для разрешения/запрета миграции старых ОС (рубильник) DIRECT-86129
     */
    WALLET_SUMS_MIGRATION_STATE("WALLET_SUMS_MIGRATION_STATE"),

    /**
     * Флаг для включание/отключения использования нового способа прогноза трат DIRECT-84075
     */
    USE_CAMP_NEW_FORECAST("USE_CAMP_NEW_FORECAST"),
    /**
     * Отправлять запросы на модерацию изменёных карточек фрилансеров.
     */
    FREELANCER_CARDS_MODERATION_SENDING_ENABLED("freelancer_cards_moderation_sending_enabled"),
    /**
     * Забирать из модерации вердикты по изменённым карточкам фрилансеров.
     */
    FREELANCER_CARDS_MODERATION_RECEIVING_ENABLED("freelancer_cards_moderation_receiving_enabled"),
    /**
     * Обновлять сертификаты фрилансеров.
     */
    FREELANCER_CERTIFICATES_UPDATING_ENABLED("freelancer_certificates_updating_enabled"),
    /**
     * Включить джобу синхронизирующую фиды из Маркета.
     */
    SYNC_MARKET_FEED_JOB_ENABLED("sync_market_feed_job_enabled"),
    /**
     * Запускать ли джобу бекапа таблиц синхронизатора.
     * 1 -- запускать
     * 0 или отсутствие значения -- не запускать
     */
    MYSQL_YT_SYNC_BACKUP_JOB_ENABLED("mysql_yt_sync_backup_job_enabled"),

    /**
     * Добавление флага "автовидео" для всех смарт-ТГО
     */
    AUTO_VIDEO_ENABLED("AUTO_VIDEO_ENABLED"),

    /**
     * Диапазоны идентификаторов креативов по шардам для джобы CanvasOperationsOnCreativesJob
     */
    JOBS_CANVAS_OPERATIONS_ON_CREATIVES_RANGES("JOBS_CANVAS_OPERATIONS_ON_CREATIVES_RANGES"),

    /**
     * Время предыдущего запуска джобы ContentCategoriesYacofastDataCollectorJob
     */
    JOBS_CONTENT_CATEGORIES_YACOFAST_DATA_COLLECTOR_LAST_START("JOBS_CONTENT_CATEGORIES_YACOFAST_DATA_COLLECTOR_LAST_START"),

    /**
     * Время предыдущего запуска джобы ContentCategoriesMobileAppsJob
     */
    JOBS_CONTENT_CATEGORIES_MOBILE_APPS_JOB_LAST_START("JOBS_CONTENT_CATEGORIES_MOBILE_APPS_JOB_LAST_START"),

    /**
     * Время предыдущего запуска джобы ContentCategoriesTolokaSecondLvlInputPrepareJob
     */
    JOBS_CONTENT_CATEGORIES_TOLOKA_INPUT_SECOND_LVL_LAST_START("JOBS_CONTENT_CATEGORIES_TOLOKA_INPUT_SECOND_LVL_LAST_START"),

    /**
     * Время предыдущего запуска джобы ContentCategoriesTolokaOutputProcessJob
     */
    JOBS_CONTENT_CATEGORIES_TOLOKA_OUTPUT_PROCESS_LAST_START("JOBS_CONTENT_CATEGORIES_TOLOKA_OUTPUT_PROCESS_LAST_START"),

    /**
     * Ежедневное количество урлов для выгрузки джобой ContentCategoriesTolokaInputPrepareJob
     */
    JOBS_CONTENT_CATEGORIES_TOLOKA_URLS_DAY_LIMIT("JOBS_CONTENT_CATEGORIES_TOLOKA_URLS_DAY_LIMIT"),

    /**
     * Ежедневное количество урлов для выгрузки джобой ContentCategoriesTolokaSecondLvlInputPrepareJob
     */
    JOBS_CONTENT_CATEGORIES_TOLOKA_SECOND_LVL_URLS_DAY_LIMIT("JOBS_CONTENT_CATEGORIES_TOLOKA_SECOND_LVL_URLS_DAY_LIMIT"),

    /**
     * Время предыдущего запуска джобы ContentCategoriesYangInputPrepareJob
     */
    JOBS_CONTENT_CATEGORIES_YANG_INPUT_PREPARE_LAST_START("JOBS_CONTENT_CATEGORIES_YANG_INPUT_PREPARE_LAST_START"),

    /**
     * Ежедневное количество урлов для выгрузки джобой ContentCategoriesYangInputPrepareJob
     */
    JOBS_CONTENT_CATEGORIES_YANG_URLS_DAY_LIMIT("JOBS_CONTENT_CATEGORIES_YANG_URLS_DAY_LIMIT"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для keywords
     */
    JOBS_AD_GENERATION_KEYWORDS_LAST_START("JOBS_AD_GENERATION_KEYWORDS_LAST_START"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для images
     */
    JOBS_AD_GENERATION_IMAGES_LAST_START("JOBS_AD_GENERATION_IMAGES_LAST_START"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для UC keywords
     */
    JOBS_AD_GENERATION_UC_KEYWORDS_LAST_START("JOBS_AD_GENERATION_UC_KEYWORDS_LAST_START"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для UC images
     */
    JOBS_AD_GENERATION_UC_IMAGES_LAST_START("JOBS_AD_GENERATION_UC_IMAGES_LAST_START"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для UC texts
     */
    JOBS_AD_GENERATION_UC_TEXTS_LAST_START("JOBS_AD_GENERATION_UC_TEXTS_LAST_START"),

    /**
     * Время предыдущего запуска обработки логов ad_generation для UC sitelinks
     */
    JOBS_AD_GENERATION_UC_SITELINKS_LAST_START("JOBS_AD_GENERATION_UC_SITELINKS_LAST_START"),

    /**
     * Процент кампаний, по которым корректировки Goal и Socdem будут отправляться и в новом формате тоже
     * (только в контент-систему, через поле ExpressionCoefs)
     */
    BS_NEW_STYLE_MULTIPLIERS_PERCENT("BS_NEW_STYLE_MULTIPLIERS_PERCENT"),

    /**
     * Процент кампаний, по которым корректировки Geo будут отправляться и в новом формате тоже
     * (только в контент-систему, через поле ExpressionCoefs)
     */
    BS_NEW_STYLE_MULTIPLIERS_GEO_PERCENT("BS_NEW_STYLE_MULTIPLIERS_GEO_PERCENT"),

    /**
     * Процент охватных кампаний, на которые автоматически добавлять пиксель подтверждения видимость (verify.yandex.ru)
     */
    FAKE_PIXEL_CPM_BANNER_PERCENT("FAKE_PIXEL_CPM_BANNER_PERCENT"),

    /**
     * Набор параметров для запуска джобы, которая заполняет таблицу yt_checksum
     * чексуммами для сверки данных с mysql2yt-full
     */
    YT_CHECKSUM_GENERATOR_PARAMS("YT_CHECKSUM_GENERATOR_PARAMS"),

    /**
     * Информация о тикете в стартреке, созданном в рамках работы джобы MysqlYtChecksumJob
     * (чтобы не создавать множественные тикеты в рамках разных запусков)
     */
    YT_CHECKSUM_JOB_REPORTING_STATE("YT_CHECKSUM_JOB_REPORTING_STATE"),

    /**
     * Показывать всем новым клиентам из Турции полный список валют
     * 1 -- показывать
     * 0 или отсутствие значения -- показывать только TRY валюту
     */
    SHOW_NEW_CURRENCIES_FOR_CLIENTS_FROM_TURKEY("SHOW_NEW_CURRENCIES_FOR_CLIENTS_FROM_TURKEY"),

    /**
     * Процент РМП-кампаний, для которых нужно генерировать сайтлинки в экспорте
     */
    MOBILE_APP_BANNERS_SITELINKS_ENABLED_PERCENT("MOBILE_APP_BANNERS_SITELINKS_ENABLED_PERCENT"),

    /**
     * Новый лимит на оплату картой рублями.
     * 0 - 49999 рублей
     * 1 - 299999 рублей
     */
    NEW_CARD_PAY_LIMIT("NEW_CARD_PAY_LIMIT"),
    ;

    private final String name;

    PpcPropertyEnum(String name) {
        checkArgument((!name.isEmpty() && name.length() <= NAME_MAX_LENGTH),
                String.format("Property name '%s'should be not empty and not longer than %d symbols", name,
                        NAME_MAX_LENGTH));
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }
}

