package ru.yandex.direct.core.entity.ppcproperty.model;

/**
 * флаг-рубильник для хранения статуса и времени последнего включения миграции новой схемы биллинга.
 * <p>
 * Требуется в нескольких модулях: intapi, jobs, web; поэтому лежит на уровне core.
 */
public class WalletMigrationStateFlag {

    private boolean enabled;

    /**
     * Время последнего включения фичи в секундах (UTC, unix time)
     */
    private Long time;

    public static WalletMigrationStateFlag disabled() {
        return new WalletMigrationStateFlag().withEnabled(false);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public Long getTime() {
        return time;
    }

    public WalletMigrationStateFlag withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public WalletMigrationStateFlag withTime(Long time) {
        this.time = time;
        return this;
    }
}
