package ru.yandex.direct.core.entity.ppcproperty.model;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.common.db.PpcPropertyNames;

import static ru.yandex.direct.common.db.PpcPropertyNames.lastAbPreparedDate;

@ParametersAreNonnullByDefault
public class WebEditablePpcProperty {
    /**
     * Сет доступных к свободному редактированию в интерфейсе пропертей.
     */
    public static final Set<PpcPropertyEnum> ALLOWED_TO_EDIT = Set.of(
            PpcPropertyEnum.USE_MODERATE_JSONRPC_PROXY_URL,
            PpcPropertyEnum.SHOW_BELARUS_OLD_RUB_WARNING,
            PpcPropertyEnum.ADFOX_INPUT_ERR_REVIEWED,
            PpcPropertyEnum.USE_JAVA_VCARDS_IN_SMART,
            PpcPropertyEnum.USE_JAVA_VCARDS_FOR_MANAGE_VCARDS,
            PpcPropertyEnum.OTHER_BANNERS_IN_MANAGE_VCARDS_PROPERTY_NAME,
            PpcPropertyEnum.DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS,
            PpcPropertyEnum.DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER,
            PpcPropertyEnum.ENABLE_EXPORT_FREELANCERS_PROJECTS_TO_YT,
            PpcPropertyEnum.DSS_CERTIFICATE_SERIAL_NUMBER,
            PpcPropertyEnum.ENABLE_IMPORT_FREELANCERS_RATING,
            PpcPropertyEnum.USE_JAVA_UPDATE_COUNTER_GRANTS,
            PpcPropertyEnum.ENABLE_LIMITED_SUPPORT_READ_ALL_CLIENTS,
            PpcPropertyEnum.URL_MONITORING_ON_LB_DRY_RUN,
            PpcPropertyEnum.URL_MONITORING_EVENTS_READ_TIMEOUT_SECONDS,
            PpcPropertyEnum.BOID_CHECK_MONITORING_ENABLED,
            PpcPropertyEnum.BOID_CHECK_MONITORING_USE_TRACKER,
            PpcPropertyEnum.BOID_CHECK_MONITORING_STATE,
            // is used in perl
            PpcPropertyEnum.URL_MONITORING_ON_LB_AND_YT_ENABLED,
            PpcPropertyEnum.AUTO_OVERDRAFT_MIN_VALUE,
            PpcPropertyEnum.LOAD_DNA_FROM_S3,
            PpcPropertyEnum.AUCTION_PROBABILITY_TOTAL_CLICKS_MEANINGFULL_DIGITS_NUMBER,
            PpcPropertyEnum.AUCTION_PROBABILITY_MIN_TOTAL_CLICKS_TO_SHOW,
            PpcPropertyEnum.UNIFIED_TURBOLANDINGS,
            PpcPropertyEnum.USE_JAVA_BIDMODIFIERS_IN_CAMPAIGN,
            PpcPropertyEnum.BS_UPDATE_PLACEMENTS_OFFSET,
            PpcPropertyEnum.JOBS_RECOMMENDATIONS_MERGE_ENABLED_ON_CLUSTERS,
            PpcPropertyEnum.JOBS_RECOMMENDATIONS_TRANSFER_ENABLED_ON_CLUSTERS,
            PpcPropertyEnum.JOBS_RECOMMENDATIONS_MERGE_SOURCES_TO_USE,
            PpcPropertyEnum.JOBS_RECOMMENDATIONS_MERGE_MR_OPERATION_TIMEOUT,
            PpcPropertyEnum.RECOMMENDATIONS_TRACER_ENABLED_TYPES,
            PpcPropertyEnum.ENABLE_BANNER_IMAGE_RESOURCES_PCT,
            PpcPropertyEnum.USE_CAMP_NEW_FORECAST,
            PpcPropertyEnum.FREELANCER_CARDS_MODERATION_SENDING_ENABLED,
            PpcPropertyEnum.FREELANCER_CARDS_MODERATION_RECEIVING_ENABLED,
            PpcPropertyEnum.RECOMMENDATIONS_MAX_ROW_COUNT_FOR_CLIENT,
            PpcPropertyEnum.MOBILE_APP_BANNERS_SITELINKS_ENABLED_PERCENT,
            PpcPropertyEnum.MYSQL_YT_SYNC_BACKUP_JOB_ENABLED,
            PpcPropertyEnum.EXPORT_BILLING_ORDER_DOMAIN_ENABLED,
            PpcPropertyEnum.EXPORT_CLUSTER_DOMAIN_ENABLED,
            PpcPropertyEnum.AUTO_VIDEO_ENABLED,
            PpcPropertyEnum.JOBS_CANVAS_OPERATIONS_ON_CREATIVES_RANGES,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_YACOFAST_DATA_COLLECTOR_LAST_START,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_MOBILE_APPS_JOB_LAST_START,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_TOLOKA_INPUT_SECOND_LVL_LAST_START,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_TOLOKA_OUTPUT_PROCESS_LAST_START,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_TOLOKA_URLS_DAY_LIMIT,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_TOLOKA_SECOND_LVL_URLS_DAY_LIMIT,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_YANG_INPUT_PREPARE_LAST_START,
            PpcPropertyEnum.JOBS_CONTENT_CATEGORIES_YANG_URLS_DAY_LIMIT,
            PpcPropertyEnum.JOBS_AD_GENERATION_KEYWORDS_LAST_START,
            PpcPropertyEnum.JOBS_AD_GENERATION_IMAGES_LAST_START,
            PpcPropertyEnum.JOBS_AD_GENERATION_UC_KEYWORDS_LAST_START,
            PpcPropertyEnum.JOBS_AD_GENERATION_UC_IMAGES_LAST_START,
            PpcPropertyEnum.JOBS_AD_GENERATION_UC_TEXTS_LAST_START,
            PpcPropertyEnum.JOBS_AD_GENERATION_UC_SITELINKS_LAST_START,
            PpcPropertyEnum.BS_NEW_STYLE_MULTIPLIERS_PERCENT,
            PpcPropertyEnum.BS_NEW_STYLE_MULTIPLIERS_GEO_PERCENT,
            PpcPropertyEnum.FAKE_PIXEL_CPM_BANNER_PERCENT,
            PpcPropertyEnum.SHOW_NEW_CURRENCIES_FOR_CLIENTS_FROM_TURKEY,
            PpcPropertyEnum.YT_CHECKSUM_GENERATOR_PARAMS,
            PpcPropertyEnum.NEW_CARD_PAY_LIMIT
    );

    /**
     * Сет доступных к свободному редактированию в интерфейсе типизированных пропертей.
     */
    @SuppressWarnings("rawtypes")
    public static final Set<PpcPropertyName> TYPED_PROPS_ALLOWED_TO_EDIT = Set.of(
            PpcPropertyNames.ADFOX_INPUT_PROCESSING_ENABLED,
            PpcPropertyNames.CMS_VIDEO_RETRANSCODE_BATCH_SIZE,
            PpcPropertyNames.CPD_JOB_ENABLED,
            PpcPropertyNames.ADFOX_OUTPUT_ENABLED,
            PpcPropertyNames.AUCTION_PROBABILITY_DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS,
            PpcPropertyNames.MOBILE_APPS_AUTO_GOALS_JOB_ENABLED,
            PpcPropertyNames.MOBILE_APPS_SYNC_JOB_ENABLED,
            PpcPropertyNames.CLIENTS_MUST_USE_NEW_VERSION_OF_ANDROID_APP,
            PpcPropertyNames.DISABLE_YND_FIXED_IN_DICTIONARIES,
            PpcPropertyNames.DEFAULT_YES_FOR_ADD_METRICA_TAG,
            PpcPropertyNames.RETURN_CAMPAIGN_SPEND_WITH_NDS_IN_API,
            PpcPropertyNames.ENABLE_UPDATE_FREELANCER_RATINGS,
            PpcPropertyNames.MIN_FREELANCER_FEEDBACKS_COUNT,
            PpcPropertyNames.ENABLE_CLEAR_OLD_LIMITED_SUPPORTS_JOB,
            PpcPropertyNames.OFFLINE_REPORT_JOB_MAX_ATTEMPTS,
            PpcPropertyNames.OFFLINE_REPORT_JOB_GRAB_DURATION_MINUTES,
            PpcPropertyNames.OFFLINE_REPORT_MIN_MONTH_FROM,
            PpcPropertyNames.OFFLINE_REPORT_MAX_REPORT_PERIOD_MONTH,
            PpcPropertyNames.AGENCY_KPI_OFFLINE_REPORT_MIN_DATE,
            PpcPropertyNames.AGENCY_KPI_OFFLINE_REPORT_MAX_DATE,
            PpcPropertyNames.AGENCY_KPI_OFFLINE_REPORT_PREMIUM_AGENCY_IDS,
            PpcPropertyNames.AGENCY_KPI_OFFLINE_REPORT_AGGREGATOR_AGENCY_IDS,
            PpcPropertyNames.CHECK_REDIRECT_IN_JAVA_PERCENT,
            PpcPropertyNames.SKIP_URL_CHECK,
            PpcPropertyNames.TRUST_REDIRECT_FROM_ANY_DOMAIN,
            PpcPropertyNames.USE_NEW_VALUES_FOR_RATE,
            PpcPropertyNames.ENABLE_SYNC_CAMP_DIALOGS_STATUS,
            PpcPropertyNames.DK2_LIMITATION_ENABLED,
            PpcPropertyNames.CONTENT_PROMOTION_AUTO_MODERATION,
            PpcPropertyNames.CPM_UAC_PROMO_COLORS,
            PpcPropertyNames.CPM_GEOPRODUCT_AUTO_MODERATION,
            PpcPropertyNames.CPM_GEO_PIN_AUTO_MODERATION,
            PpcPropertyNames.CONTENT_PROMOTION_COLLECTION_AUTO_MODERATION,
            PpcPropertyNames.ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB,
            PpcPropertyNames.DO_CREATE_WALLET_IN_ADD_OR_GET,
            PpcPropertyNames.ENABLE_DAAS_JOB,
            PpcPropertyNames.TEMPLATE_PLACE_LAST_UPDATE_UNIX_TIME,
            PpcPropertyNames.TEMPLATE_RESOURCE_LAST_UPDATE_UNIX_TIME,
            PpcPropertyNames.BANNERS_UNREACHABLE_URL_STOP_BANNERS_ENABLED,
            PpcPropertyNames.BANNERS_UNREACHABLE_URL_IDS_NOT_DISABLE,
            PpcPropertyNames.BANNERS_UNREACHABLE_URL_URLS_NOT_DISABLE,
            PpcPropertyNames.BANNERS_UNREACHABLE_URL_ERRORS_NOT_DISABLE,
            PpcPropertyNames.DISABLED_ESS_LOGIC_PROCESSORS,
            PpcPropertyNames.DISABLED_ESS_RULES,
            PpcPropertyNames.BUSINESS_CATEGORIES_SET,
            PpcPropertyNames.RECOGNIZED_BANNER_LANGUAGES_SET,
            PpcPropertyNames.TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CACHE,
            PpcPropertyNames.TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_DELAY,
            PpcPropertyNames.TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CLEAR,
            PpcPropertyNames.VIDEOGOALS_OUTDOOR_UPDATE_ENABLED,
            PpcPropertyNames.VIDEOGOALS_OUTDOOR_UPDATE_READ_LOG_DATE_START,
            PpcPropertyNames.VIDEOGOALS_OUTDOOR_UPDATE_READ_LOG_DATE_END,
            PpcPropertyNames.GBP_CLIENT_UID,
            PpcPropertyNames.GBP_AGENCY_CLIENT_ID,
            PpcPropertyNames.DAAS_COLLECTIONS_UIDS,
            PpcPropertyNames.DAAS_ORGANIZATIONS_UIDS,
            PpcPropertyNames.SAVE_CONTENT_PROMOTION_VIDEO_NEW_SCHEMA,
            PpcPropertyNames.CLIENTS_AVATARS_DELETION_ENABLED,
            PpcPropertyNames.IS_HOURGLASS_ENABLED,
            PpcPropertyNames.ALLOW_MASS_ADD_REMOVE_PERMALINKS_IN_SYNC_JOB,
            PpcPropertyNames.UPDATE_PERMALINKS_JOB_IN_JAVA_ENABLED,
            PpcPropertyNames.ENABLE_PROXY_FOR_ANALYZE_TEXT_LANG,
            PpcPropertyNames.USE_NEW_DIRECT_SUBMISSIONS_URL,
            PpcPropertyNames.USE_JOBS_ORGANIZATIONS_REQUESTS,
            PpcPropertyNames.CLIENTS_WITH_ENABLED_UZBEK_LANGUAGE,
            PpcPropertyNames.CLIENTS_WITH_DEFAULT_VIE_LANGUAGE,
            PpcPropertyNames.CYRILLIC_UZBEK_TO_RUSSIAN_THRESHOLD,
            PpcPropertyNames.LATIN_UZBEK_TO_RUSSIAN_THRESHOLD,
            PpcPropertyNames.UZBEK_TO_TURKISH_THRESHOLD,
            PpcPropertyNames.UZBEK_TO_UNKNOWN_THRESHOLD,
            PpcPropertyNames.USE_TURBO_APP_HANDLE,
            PpcPropertyNames.UPDATE_TURBO_APPS_ON_VIEW,
            PpcPropertyNames.PPCHOUSE_CLEANER_REAL_REMOVE,
            PpcPropertyNames.DISABLE_OLD_UC,
            PpcPropertyNames.RECALCULATE_CAMPAIGNS_STATUS_JOB_SLEEP_COEFFICIENT,
            PpcPropertyNames.METRIKA_SEGMENT_PRESETS_COUNTERS_LIMIT,
            PpcPropertyNames.FRAUD_PROMO_REDIRECTS_LAST_ROW,
            PpcPropertyNames.OVERDRAFT_LIMIT_MAILER_LAST_TABLE_NAME,
            PpcPropertyNames.BS_AGENCY_IDS_FOR_DIRECT_MONITORING,
            PpcPropertyNames.DIRECT_CID_TO_SKADNETWORK_CAMPAIGN_ID,
            PpcPropertyNames.SKADNETWORK_APP_SLOTS_NUMBER,
            PpcPropertyNames.MEANINGFUL_GOAL_VALUE_SERIALIZE_AS_STRING,
            PpcPropertyNames.USE_CAMP_AGGREGATED_LASTCHANGE_PROPERTY,
            PpcPropertyNames.DISABLE_KARMA_CAPTCHA,
            PpcPropertyNames.DEFAULT_INLFY_REQUESTS_LIMIT,
            PpcPropertyNames.INFLY_REQUESTS_SHOW_CAPTCHA,
            PpcPropertyNames.TELEPHONY_PLAYBACK_ID,
            PpcPropertyNames.TELEPHONY_SERVICE_NUMBER_ACTION_PROCESSING_ENABLED,
            PpcPropertyNames.TELEPHONY_DETACHING_ENABLED,
            PpcPropertyNames.TELEPHONY_ATTACHING_ENABLED,
            PpcPropertyNames.MAX_DAYS_WITHOUT_SHOWS_FOR_ADV_TELEPHONY_PHONE,
            PpcPropertyNames.MAX_DAYS_WITHOUT_ACTIONS_FOR_SITE_TELEPHONY_PHONE,
            PpcPropertyNames.TELEPHONY_CALC_LAST_SHOW_TIME_ENABLED,
            PpcPropertyNames.CALLTRACKING_UNLINK_PHONE_ENABLED,
            PpcPropertyNames.WELCOME_PAGE_AUTOCOMPLETE_ENABLED_FOR_UIDS,
            PpcPropertyNames.COLLECTING_VERIFIED_PHONES_DISABLED_FOR_COUNTRIES,
            PpcPropertyNames.PHONE_VERIFICATION_MAX_CALLS_COUNT_PER_DAY,
            PpcPropertyNames.NUMBER_OF_PARALLEL_REQUESTS_TO_METRIKA,
            PpcPropertyNames.MAX_COUNTERS_IN_PRODUCT_IMPRESSIONS,
            PpcPropertyNames.DELETE_KEYWORDS_FROM_BIDS_BASE_RELAX_TIME,
            PpcPropertyNames.INSERT_TO_BIDS_PHRASEID_ASSOCIATE_RELAX_TIME,
            PpcPropertyNames.SEND_ASSET_HASH_ENABLED,
            PpcPropertyNames.SEND_ASSET_HASH_INCLUDED_FOR_ALL_TYPES_ENABLED,
            PpcPropertyNames.CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES,
            PpcPropertyNames.UAC_CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES,
            PpcPropertyNames.AGGREGATED_STATUS_PARALLEL,
            PpcPropertyNames.ENABLE_CALCULATION_LACK_OF_CONVERSION_AGGREGATED_STATUS,
            PpcPropertyNames.CALLTRACKING_PHONES_WITHOUT_REPLACEMENTS_PARSE_WATCH_LOG_LAST_READ_TIME,
            PpcPropertyNames.PHONES_WITHOUT_REPLACEMENTS_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.POPULATE_SUGGEST_CONVERSION_PRICE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.USE_GOZORA_IN_PROCESS_IMAGES_QUEUE,
            PpcPropertyNames.METRIKA_INTAPI_TIMEOUT_DURATION_SECONDS,
            PpcPropertyNames.METRIKA_AUDIENCE_API_TIMEOUT_DURATION_SECONDS,
            PpcPropertyNames.METRIKA_API_TIMEOUT_DURATION_SECONDS,
            PpcPropertyNames.CROSS_DEVICE_DEFAULT_ATTRIBUTION_TYPE_ENABLED,
            PpcPropertyNames.ADD_DEFAULT_SITE_FILTER_CONDITION_ENABLED,

            PpcPropertyNames.ONESHOT_RELAXED_PAUSE_PERCENT,

            //NotifyClientCashbackJob
            PpcPropertyNames.NOTIFY_CASHBACK_CLUSTER,
            PpcPropertyNames.NOTIFY_CASHBACK_DIRECTORY,
            PpcPropertyNames.NOTIFY_CASHBACK_TABLE_CREATTION_TIME,
            PpcPropertyNames.NOTIFY_CASHBACK_ROW_NUMBER,
            PpcPropertyNames.NOTIFY_CASHBACK_CHUNK_SIZE,

            PpcPropertyNames.HOME_DIRECT_DB_DATE,
            PpcPropertyNames.HOME_DIRECT_DB_INCLUDE,
            PpcPropertyNames.HOME_DIRECT_DB_EXCLUDE,
            PpcPropertyNames.HOME_DIRECT_DB_POOL,
            PpcPropertyNames.HOME_DIRECT_DB_FULL_WORK,
            PpcPropertyNames.YT_PROD_MYSQL_SHARDS_COUNT,

            PpcPropertyNames.YT_CHECKSUM_TABLES_INCLUDE,
            PpcPropertyNames.YT_CHECKSUM_TABLES_EXCLUDE,
            PpcPropertyNames.YT_CHECKSUM_DEST_PATH,
            PpcPropertyNames.YT_CHECKSUM_USE_TRACKER,
            PpcPropertyNames.YT_CHECKSUM_TRACKER_QUEUE,
            PpcPropertyNames.YT_CHECKSUM_COLUMNS_EXCLUDE,

            //price package
            PpcPropertyNames.PRICE_PACKAGE_BS_TEMPLATE_WHITE_LIST,

            // collecting segments
            PpcPropertyNames.SEGMENT_JOBS_IGNORE_MISSED_DAYS,
            PpcPropertyNames.SEGMENT_JOBS_SEGMENTS_LIMIT,
            PpcPropertyNames.SEGMENT_JOBS_INTERMEDIATE_START_LOG_DATE,
            PpcPropertyNames.SEGMENT_JOBS_CPM_INTERMEDIATE_START_LOG_DATE,
            PpcPropertyNames.SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS,
            PpcPropertyNames.SEGMENT_JOBS_RUN_GREEDY_JOBS,
            PpcPropertyNames.SEGMENT_JOBS_RUN_TEXT_GREEDY_JOBS,
            PpcPropertyNames.SEGMENT_JOBS_DATA_LIMIT,

            PpcPropertyNames.BILLING_ORDER_DOMAINS_COST_THRESHOLD,
            PpcPropertyNames.BILLING_ORDER_DOMAINS_COUNT_THRESHOLD,

            // cashback
            PpcPropertyNames.LAST_IMPORTED_CASHBACK_MONTH,
            PpcPropertyNames.LAST_IMPORTED_CASHBACK_TABLE,
            PpcPropertyNames.IMPORT_CASHBACK_REWARDS_DETAILS_ENABLED,

            // autobudget restart
            PpcPropertyNames.AUTOBUDGET_RESTART_AUTOBUDGET_AVG_BID_MARGIN,
            PpcPropertyNames.AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPM_MARGIN,
            PpcPropertyNames.AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPA_MARGIN,
            PpcPropertyNames.AUTOBUDGET_RESTART_PAUSE_SECONDS_MARGIN,
            PpcPropertyNames.AUTOBUDGET_RESTART_SEND_TO_BS_ON_NEW_MONEY,
            PpcPropertyNames.ACTIVE_ORDERS_RESEND_CHANGED_CAMPAIGNS,
            PpcPropertyNames.ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_ORDERIDS,
            PpcPropertyNames.ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_PERCENT,

            PpcPropertyNames.CHECK_CASHBACK_ONLY_ON_NEW_MONEY,
            PpcPropertyNames.EXPORT_ADVQ_HITS_LAST_PROCESSED_WEEK_NUMBER,
            PpcPropertyNames.MODERATE_EXPORT_DISABLE_PESSIMIZATION,
            PpcPropertyNames.CAMP_COPY_QUEUE_ADDITIONAL_WORKERS,
            PpcPropertyNames.CAMP_COPY_QUEUE_SLEEP_COEF,
            PpcPropertyNames.USE_YT_STATISTICS_FOR_UC,

            PpcPropertyNames.SHOW_AUTO_APPLY_CHANGES_IN_USER_LOGS,

            // used in perl
            PpcPropertyNames.ENABLE_NEW_CAMPS_HAS_ACTIVE_BANNERS_REQUEST,
            PpcPropertyNames.BS_BIDS_LIMITED_BY_DAY_BUDGET,
            PpcPropertyNames.BS_EXPORT_SECOND_QUERY_DISABLE_PERCENT,
            PpcPropertyNames.BS_EXPORT_SECOND_QUERY_DISABLE_CLIENT_IDS,
            PpcPropertyNames.BS_EXPORT_HEAVY_SHAKE_ENABLED,
            PpcPropertyNames.ADVQ_SKIP_CAMP_MINUS_WORDS,
            PpcPropertyNames.ALW_EVENT_BATCH_SIZE,
            PpcPropertyNames.BS_CAMPS_ONLY_CAMPS_LIMIT,
            PpcPropertyNames.BS_INVENTORY_TYPE_COEF_INBANNER_ENABLED,
            PpcPropertyNames.CAMP_ARC_QUEUE_SLEEP_COEF,
            PpcPropertyNames.ARC_CAMPAIGN_SLEEP_COEF,
            PpcPropertyNames.ENRICH_PLACEMENTS_GEO_LAST_UPDATE_TIME,
            PpcPropertyNames.ENRICH_PLACEMENTS_GEO_IGNORE_OLD_GEO,
            PpcPropertyNames.ENRICH_PLACEMENTS_ADDRESS_LAST_UPDATE_TIME,
            PpcPropertyNames.CALCULATE_IMPLICIT_CPA_MAX_BID_IN_TRANSPORT,
            PpcPropertyNames.REMODERATE_COPIED_CAMPAIGNS,
            PpcPropertyNames.PROMOCODE_DOMAIN_CLIENT_CHECK_IS_ENABLED,
            PpcPropertyNames.MODERATE_EVERY_KEYWORD_CHANGE,
            PpcPropertyNames.OLD_MODERATE_EXPORT_WORKERS_REMAPPING,
            PpcPropertyNames.OLD_MODERATE_EXPORT_AUTO_BALANCING_WORKERS,
            PpcPropertyNames.OLD_MODERATE_EXPORT_MIN_WORKERS_TO_KEEP,
            PpcPropertyNames.OLD_MODERATE_EXPORT_MAX_WORKERS_TO_ADD,
            PpcPropertyNames.USE_BLACKBOX_TVM,
            PpcPropertyNames.MODERATE_TEXT_LIMITS_ADGROUPS,
            PpcPropertyNames.EXPORT_PREPROD_USAGE_PCT_PROP_NAME,
            PpcPropertyNames.BS_EXPORT_SOAP_STRIP_KEYS_PERCENT,
            PpcPropertyNames.BS_CLIENT_DATA_SKIP_BSSOAP_REQUEST,
            PpcPropertyNames.BS_CLIENT_DATA_SKIP_BSSOAP_INTERNAL_ADS_REQUEST,
            PpcPropertyNames.AUTOPAY_PAYMENT_SUM,
            PpcPropertyNames.AUTOPAY_REMAINING_SUM,
            PpcPropertyNames.AUTOOVERDRAFT_SUGGEST_COEF,
            PpcPropertyNames.NEW_PAYMENT_WORKFLOW_AUTOPAY_SAVE_PERIOD,
            PpcPropertyNames.UAAS_ENABLED,
            PpcPropertyNames.ENABLE_ADGROUP_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_ADGROUP_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_ADGROUP_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_CAMPAIGN_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_CAMPAIGN_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_CAMPAIGN_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.CAMPAIGN_TRANSPORT_NEW_MODERATION_MODIFY_STATUS,
            PpcPropertyNames.TURBOLANDINGS_NEW_TRANSPORT_ENABLED_JAVA,
            PpcPropertyNames.TURBOLANDINGS_NEW_TRANSPORT_ENABLED_PERL,
            PpcPropertyNames.DISABLE_DISPLAYHREFS_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.ENABLE_DISPLAYHREFS_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_SITELINKS_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_SITELINKS_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.ENABLE_AD_IMAGE_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_AD_IMAGE_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.ENABLE_IMAGE_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_IMAGE_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.ENABLE_CALLOUT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_CALLOUT_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_CALLOUT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_CANVAS_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_CANVAS_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_CANVAS_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_CPC_VIDEO_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_CPC_VIDEO_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_CPC_VIDEO_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_DYNAMIC_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_DYNAMIC_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_DYNAMIC_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_MOBILE_CONTENT_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_TEXT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_TEXT_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_TEXT_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_VCARD_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_VCARD_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_VCARD_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_MOBILE_CONTENT_ICON_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_VIDEO_ADDITION_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_HTML5_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.DISABLE_HTML5_TRANSPORT_OLD_MODERATION,
            PpcPropertyNames.RESTRICTED_HTML5_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_FLAGS_TRANSPORT_NEW_MODERATION,
            PpcPropertyNames.ENABLE_BANNER_ARCHIVING_TRANSPORT,
            PpcPropertyNames.ENABLE_BANNER_ARCHIVING_BY_CAMPAIGN_TRANSPORT,
            PpcPropertyNames.SAVE_MINUS_REGIONS_AS_BANNER_FLAGS,
            PpcPropertyNames.SAVE_MINUS_REGIONS_AS_BANNER_FLAGS_ENABLED_CAMPAIGN_IDS,
            PpcPropertyNames.PASSPORT_VERIFICATION_PAGE_ENABLED,
            PpcPropertyNames.FIX_JOB_ID_IN_API4,
            PpcPropertyNames.ENABLE_MODERATE_EXPORT_MASTER,
            PpcPropertyNames.AGGREGATED_CAMP_STATUS_MODERATE,
            PpcPropertyNames.AGGREGATED_CAMP_STATUS_MODERATE_JAVA,
            PpcPropertyNames.AGGREGATED_CAMP_STATUS_MODERATE_JAVA_PREFER_NEW_CALCULATOR,
            PpcPropertyNames.PARSE_WATCH_LOG_CLUSTER,
            PpcPropertyNames.PARSE_WATCH_LOG_LAST_READ_TIME,
            PpcPropertyNames.PARSE_WATCH_LOG_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.PARSE_WATCH_LOG_WEAK_RESTRICTIONS_LAST_READ_TIME,
            PpcPropertyNames.PARSE_WATCH_LOG_WEAK_RESTRICTIONS_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.PARSE_HIT_LOG_CLUSTER,
            PpcPropertyNames.PARSE_HIT_LOG_LAST_READ_TIME,
            PpcPropertyNames.PARSE_HIT_LOG_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.METRIKA_COUNTER_IDS_EXCLUDED_FROM_AUTOCOMPLETE,
            PpcPropertyNames.METRIKA_COUNTER_LIFETIME_IN_DAYS_FOR_AUTOCOMPLETE,
            PpcPropertyNames.METRIKA_COUNTER_USE_WEAK_RESTRICTIONS_FOR_SUGGESTION,
            PpcPropertyNames.METRIKA_COUNTER_WITH_WEAK_RESTRICTIONS_LIFETIME_IN_DAYS,
            PpcPropertyNames.MARKET_FEEDS_SYNC_ENABLED,
            PpcPropertyNames.IS_NEW_REQWIZARD_ENABLED,
            PpcPropertyNames.BL_SELECT_CHUNK_SIZE,
            PpcPropertyNames.BL_CHUNK_SIZE,
            PpcPropertyNames.BS_TRANSPORT_CHANGE_DAY_WEIGHT,
            PpcPropertyNames.HIDE_DOUBLE_IMAGE_FIELDS_TO_BS_ENABLED,
            PpcPropertyNames.SINGLE_IMAGE_AD_TO_BS_IN_OLD_SCHEME_SLEEP,
            PpcPropertyNames.BL_MAX_ERRORS_COUNT,
            PpcPropertyNames.BL_RECHECK_INTERVAL_ERROR,
            PpcPropertyNames.BS_AUCTION_SOFT_TIMEOUT_SECONDS,
            PpcPropertyNames.BS_AUCTION_LOG_RETRY_REQUESTS,
            PpcPropertyNames.BS_AUCTION_USE_WEB_CLIENT,
            PpcPropertyNames.BS_AUCTION_IGNORE_PHRASEID_HISTORY,
            PpcPropertyNames.ANOTHER_PHONE_FOR_MAIN_PAGE,
            PpcPropertyNames.MORDA_LANDING_PAGE_REDIRECT_PERCENT,
            PpcPropertyNames.MORDA_LANDING_PAGE_INTERNAL_REDIRECT,
            PpcPropertyNames.HAS_SEARCH_VOLUME_MAX_REQUESTS_BY_APPLICATION,
            PpcPropertyNames.CALLBACK_FORM_FOR_MAIN_PAGE,
            PpcPropertyNames.SUPPORT_CHAT_FOR_MAIN_PAGE,
            PpcPropertyNames.CREATE_ORGANIZATION_METRIKA_COUNTER,
            PpcPropertyNames.SUPPRESS_METRIKA_ERRORS_IN_SHOW_STAT,
            PpcPropertyNames.SAVE_AVAILABLE_COUNTERS_GOALS_ON_CAMPAIGN_SAVING_IN_API,
            PpcPropertyNames.YANDEX_URL_TO_SERVICE_MAPPINGS,
            PpcPropertyNames.YANDEX_SERVICES_WITHOUT_SPECIAL_DOMAIN,
            PpcPropertyNames.CALLTRACKING_PARSE_WATCH_LOG_LAST_READ_TIME,
            PpcPropertyNames.CALLTRACKING_NUMBER_CLICKS_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.CALLTRACKING_EXTERNAL_BY_DOMAIN_POPULATE_DYN_TABLE_JOB_ENABLED,
            PpcPropertyNames.CALLTRACKING_EXTERNAL_BY_DOMAIN_PARSE_WATCH_LOG_LAST_READ_TIME,
            PpcPropertyNames.DOMAIN_BLACKLIST_FOR_IMAGE_SEARCH,
            PpcPropertyNames.DOMAIN_BLACKLIST_FOR_SITELINK_GENERATION,
            PpcPropertyNames.DOMAIN_BLACKLIST_FOR_TEXT_RCA,
            PpcPropertyNames.CALLTRACKING_SYNC_PHONES_POOL_BATCH_SIZE,
            PpcPropertyNames.CALLTRACKING_SYNC_PHONES_POOL_DELETE_OLDER_THAN_DAYS,
            PpcPropertyNames.RESYNC_BANNER_RESOURCES_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_BANNER_RESOURCES_RELAX_TIME,
            PpcPropertyNames.RESYNC_CAMPAIGNS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_MEANINGFUL_GOALS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_STRATEGIES_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_STRATEGIES_RELAX_TIME,
            PpcPropertyNames.RESYNC_CAMPAIGNS_RELAX_TIME,
            PpcPropertyNames.RESYNC_MEANINGFUL_GOALS_RELAX_TIME,
            PpcPropertyNames.RESYNC_AD_GROUPS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_AD_GROUPS_RELAX_TIME,
            PpcPropertyNames.RESYNC_AD_GROUP_SHOW_CONDITIONS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_AD_GROUP_SHOW_CONDITIONS_RELAX_TIME,
            PpcPropertyNames.RESYNC_BIDDABLE_SHOW_CONDITIONS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_BIDDABLE_SHOW_CONDITIONS_RELAX_TIME,
            PpcPropertyNames.RESOURCES_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK,
            PpcPropertyNames.AD_GROUPS_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK,
            PpcPropertyNames.AD_GROUPS_SHOW_CONDITION_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK,
            PpcPropertyNames.BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_CHUNK,
            PpcPropertyNames.BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_RELAX_TIME,
            PpcPropertyNames.IMPORT_CRYPTA_SEGMENTS_FOR_CA_ENABLED,
            PpcPropertyNames.IMPORT_SITELINKS_FROM_BNO_ENABLED,
            PpcPropertyNames.DISABLE_MODERATION_NOTIFICATIONS,
            PpcPropertyNames.ZEN_BS_TRANSPORT_QUEUE_ON_CREATION,
            PpcPropertyNames.MODERATION_REASONS_ALLOWABLE_TO_REMODERATE_BY_CLIENT,
            PpcPropertyNames.SPECIAL_VALIDATIONS_FOR_UAC,
            PpcPropertyNames.SOCIAL_ADVERTISING_PACKAGES,
            PpcPropertyNames.SUGGEST_REGION_SOURCES,
            PpcPropertyNames.SUGGEST_REGION_TYPES,
            PpcPropertyNames.SUGGEST_REGION_WEIGHT_MULTIPLIER_BY_SOURCE,
            PpcPropertyNames.SUGGEST_REGION_WEIGHT_MULTIPLIER_BY_TYPE_AND_SOURCE,
            PpcPropertyNames.CORRECT_REGISTER_FOR_SUGGESTS,
            PpcPropertyNames.CAMP_OPERATIONS_QUEUE_COPY_AGE_LIMIT_HOURS,
            PpcPropertyNames.AGGR_STATUSES_RESYNC_QUEUE_AGE_LIMIT_MINUTES,
            PpcPropertyNames.USE_GO_ZORA,
            PpcPropertyNames.RECALCULATE_AGGREGATED_STATUSES_ON_SAVE_UC,
            PpcPropertyNames.USE_BANNERS_ADD_UAC_TGO_UPDATE_PREVALIDATION,
            PpcPropertyNames.RECALCULATE_AGGREGATED_STATUSES_ON_UPDATE_STATUS_UC,
            PpcPropertyNames.TRACE_LOG_LOGBROKER_MONITORING_NOT_FULL_SIZE,
            PpcPropertyNames.TRACE_LOG_MONITORING_LIMIT,
            PpcPropertyNames.TRACE_LOG_MONITORING_SLEEP_TIME_MS,
            PpcPropertyNames.USE_INT_API_METRIKA_FOR_GOAL_CONVERSIONS_COUNT,
            PpcPropertyNames.ORDER_STAT_MAX_SUBQUERIES,
            PpcPropertyNames.ORDER_STAT_DISABLED_CLUSTERS,
            PpcPropertyNames.USE_ONLY_SENECA_SAS_FOR_GRID_STATTISTIC,
            PpcPropertyNames.USE_STAT_CLUSTER_CHOOSER_FOR_GRID_STATTISTIC,
            PpcPropertyNames.ORDER_STAT_SKIP_SHARDS,
            PpcPropertyNames.ESS_MODERATION_LOGBROKER_READER_ROWS_LIMIT,
            PpcPropertyNames.INCREASE_AD_TEXT_LIMITS,
            PpcPropertyNames.AGGREGATED_STATUS_RESYNC_QUEUE_ENABLED,
            PpcPropertyNames.AGGREGATED_STATUS_RESYNC_QUEUE_PREPARING_TABLES_ENABLED,
            PpcPropertyNames.CLIENTS_FEATURES_CHANGES_LOG_JOB_IGNORED_FEATURES_IDS,
            PpcPropertyNames.DAYS_TO_LIVE_OF_RESPONSE_FOR_NOT_SHARED_LOGVIEWER_QUERY,
            PpcPropertyNames.DAYS_TO_LIVE_OF_RESPONSE_FOR_SHARED_LOGVIEWER_QUERY,
            PpcPropertyNames.USE_INTAPI_FOR_ACTIVE_ORDERS_MONEY_OUT,
            PpcPropertyNames.MAX_BANNERS_IN_UAC_AD_GROUP,
            PpcPropertyNames.MAX_BANNERS_IN_UAC_TEXT_AD_GROUP,
            PpcPropertyNames.START_SEARCH_STATS_FROM_DATE_FOR_UAC,
            PpcPropertyNames.DO_NOT_RESTORE_REMOVED_ASSETS_IN_UAC_TGO,
            PpcPropertyNames.FILTER_UAC_BANNERS_IN_ALW,
            PpcPropertyNames.CHANGE_REJECTED_ASSET_TO_CREATED_WITH_SECONDS_SHIFT,
            PpcPropertyNames.SEND_CAMPAIGNS_TO_ESS_TRANSPORT_OBJECTS_LIMIT,
            PpcPropertyNames.MYSQL2GRUT_RESEND_OBJECTS_LIMIT,
            PpcPropertyNames.CLEAN_CONVERSION_BID_MODIFIERS_CHUNK_SIZE,
            PpcPropertyNames.CLEAN_CONVERSION_BID_MODIFIERS_RELAX_TIME,
            PpcPropertyNames.CAMPAIGN_TO_PACKAGE_STRATEGY_MIGRATION_CHUNK_SIZE,
            PpcPropertyNames.CAMPAIGN_TO_PACKAGE_STRATEGY_MIGRATION_RELAX_TIME,
            PpcPropertyNames.USE_CAMP_AGGR_STATUS_FOR_ACTIVE_BANNERS_FLAG,
            PpcPropertyNames.OPTIMIZE_CAMP_BANNERS_FLAGS,
            PpcPropertyNames.DOMAINS_NOT_ALLOWED_FOR_FEED_FROM_SITE,
            PpcPropertyNames.DOMAINS_NOT_ALLOWED_FOR_UNAVAILABLE_COUNTERS,
            PpcPropertyNames.CAMP_DAY_BUDGET_LIMIT_STOP_TIME_JAVA_WRITING_ENABLED,
            PpcPropertyNames.CIDS_TO_SKIP_IN_STATUSES_PROCESSOR,
            PpcPropertyNames.SEND_TURBO_SITE_AS_DOMAIN_PLACEHOLDER,
            PpcPropertyNames.BS_EXPORT_ESS_BIDDABLE_SHOWS_CONDITIONS_RET_COND_IDS_IGNORED,
            PpcPropertyNames.UAC_TARGET_INTERESTS_ENABLED,
            PpcPropertyNames.SYNC_UAC_PHRASES_TO_STORAGE,
            PpcPropertyNames.CHANGE_NOTIFICATION_MESSAGES_FOR_DAYS_WARNING_WALLET,
            PpcPropertyNames.SHOW_STATS_BY_UNAVAILABLE_GOALS_IN_MOL,
            PpcPropertyNames.IS_GRUT_ENABLED,
            PpcPropertyNames.IS_GRUT_BACKENDS_VIA_YP_ENABLED,
            PpcPropertyNames.FETCH_DATA_FROM_GRUT_FOR_AGGR_STATUSES,
            PpcPropertyNames.FETCH_DATA_FROM_GRUT_FOR_CAMP_AGGREGATED_LASTCHANGE,
            PpcPropertyNames.PROCESS_WATCHLOG_IN_UAC_PROCESSOR,
            PpcPropertyNames.FETCH_DATA_FROM_GRUT_FOR_ASSET_LINK_STATUSES,
            PpcPropertyNames.GRUT_TRACE_SAMPLING_ENABLED,
            PpcPropertyNames.GRUT_READ_WATCHLOG_IN_ESS,
            PpcPropertyNames.GRUT_WRITE_WATCHLOG_IN_ESS,
            PpcPropertyNames.GRUT_WATCHLOG_ITERATIONS_BEFORE_COMMIT,
            PpcPropertyNames.WATCHLOGBROKER_BANNER_CANDIDATE_PROCESSOR_ENABLED,
            PpcPropertyNames.WATCHLOGBROKER_CAMPAIGN_PROCESSOR_ENABLED,
            PpcPropertyNames.ESS_WATCHLOG_PROCESSING_TIMEOUT_SEC,
            PpcPropertyNames.GRUT_LIST_CONTAINS_BATCH_SIZE,
            PpcPropertyNames.GRUT_CAMPAIGNS_BATCH_SIZE,
            PpcPropertyNames.GRUT_CAMP_REPL_ASYNC_UPDATE,
            PpcPropertyNames.GRUT_REPL_ASYNC_UPDATE,
            PpcPropertyNames.GRUT_CAMP_REPL_CALC_AUTOBUDGET_RESTART_PERCENT,
            PpcPropertyNames.GRUT_SKIP_CAMPAIGNS_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_ADGROUPS_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_BANNERS_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_STRATEGIES_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_MINUS_PHRASES_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_MOBILE_CONTENT_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_RETARGETING_CONDITION_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_VCARDS_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_CREATIVES_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_BIDDABLE_SHOW_CONDITION_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_SKIP_BID_MODIFIERS_REPLICATION_SHARDS,
            PpcPropertyNames.GRUT_AD_GROUPS_FILL_BIDDABLE_SHOW_CONDITIONS,
            PpcPropertyNames.GRUT_REPLICATION_CREATE_OR_UPDATE_BATCH_SIZE,
            PpcPropertyNames.GRUT_REPLICATION_GET_BATCH_SIZE,
            PpcPropertyNames.GRUT_REPLICATION_DELETE_BATCH_SIZE,
            PpcPropertyNames.GRUT_REPLICATION_BANNERS_DB_LOAD_CHUNK_SIZE,
            PpcPropertyNames.GRUT_REPLICATION_CAMPAIGNS_DB_LOAD_CHUNK_SIZE,
            PpcPropertyNames.GRUT_REPLICATION_CALC_AUTOBUDGET_RESTART_CHUNK_SIZE,
            PpcPropertyNames.GRUT_USE_MYSQL_TABLE_FOR_AUTOBUDGET_RESTART_REPLICATION,
            PpcPropertyNames.BS_TRANSPORT_STOP_REJECTED_BANNERS,
            PpcPropertyNames.KEYWORD_RECOMMENDATION_SERVICE_USE_MINUS_WORDS,
            PpcPropertyNames.KEYWORD_RECOMMENDATION_SERVICE_USE_KEYWORDS,
            PpcPropertyNames.UC_UAC_CONVERTER_CHUNK_SIZE,
            PpcPropertyNames.GRUT_UAC_CONVERTER_CHUNK_SIZE,
            PpcPropertyNames.SHOW_DNA_ABT_INFO_SOFT_TIMEOUT,
            PpcPropertyNames.SHOW_DNA_ABT_INFO_NUM_ATTEMPTS,
            PpcPropertyNames.BS_EXPORT_METRIKA_COUNTERS_HASH_ENABLED,
            PpcPropertyNames.RESYNC_METRIKA_COUNTERS_CHUNK_SIZE,
            PpcPropertyNames.RESYNC_METRIKA_COUNTERS_RELAX_TIME,
            PpcPropertyNames.PREVIEW_TOPIC_READS_COUNT,
            PpcPropertyNames.FEATURES_PARALLEL_REQUEST,
            PpcPropertyNames.BLACKBOX_USE_MULTISESSION,
            PpcPropertyNames.MIN_OFFERS_COUNT_BY_HOST_FOR_SEND_TO_MBI,
            PpcPropertyNames.BS_EXPORT_FIX_ORDER_TYPE_PERCENT,
            PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_CAMPAIGN_ENABLED,
            PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_BY_CLIENT_IDS,
            PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_AD_GROUPS_ENABLED,
            PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_BY_CAMPAIGN_IDS,
            PpcPropertyNames.BS_EXPORT_OLD_RF_DISABLED_PLACE_IDS,
            PpcPropertyNames.BS_EXPORT_OLD_RF_FILTER_INTERNAL_AD_GROUPS_ENABLED,
            PpcPropertyNames.BS_EXPORT_OLD_RF_FILTER_BY_CAMPAIGN_IDS,
            PpcPropertyNames.BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_ENABLED,
            PpcPropertyNames.BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_BY_BIDS,
            PpcPropertyNames.BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_ENABLED,
            PpcPropertyNames.BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_BY_BIDS,
            PpcPropertyNames.BS_EXPORT_TARGET_FLAT_DISABLED_PERCENT,
            PpcPropertyNames.BS_TRANSPORT_SEND_ADVANCED_GEOTARGETING_DATA,
            PpcPropertyNames.MAX_TEXTS_IN_UAC,
            PpcPropertyNames.MAX_TITLES_IN_UAC,
            PpcPropertyNames.ENABLE_ORIG_THUMB_IN_UAC,
            PpcPropertyNames.USE_NEXT_GEO_TREE,
            PpcPropertyNames.MONEY_OUT_REMINDER_JOB_ON,
            PpcPropertyNames.DO_NOT_SEND_EXTRA_BANNER_IMAGE_FORMATS_TO_BS,
            PpcPropertyNames.USE_NEW_CRITERION_ID,
            PpcPropertyNames.FLAT_CPC_FROM_YT_MIGRATION_RELAX_TIME,
            PpcPropertyNames.FLAT_CPC_FROM_YT_MIGRATION_SHOULD_LOG_BIDS_CHANGES,
            PpcPropertyNames.MAX_NUMBER_OF_CIDS_ABLE_TO_LINK_TO_PACKAGE_STRATEGY,
            PpcPropertyNames.HYPER_GEO_IDS_TO_DELETE_LIMIT,
            PpcPropertyNames.HYPER_GEO_SEGMENT_IDS_TO_BYPASS_DELETING,
            PpcPropertyNames.ENABLE_ALTERNATIVE_APP_STORES,
            PpcPropertyNames.PACKAGE_STRATEGY_IDENTIFIERS_MIGRATION_BATCH_LIMIT,
            PpcPropertyNames.PACKAGE_STRATEGY_AUTOBUDGET_RESTART_TRANSPORT_ENABLED,
            PpcPropertyNames.PACKAGE_STRATEGY_AUTOBUDGET_RESTART_MIGRATION_BATCH_SIZE,
            PpcPropertyNames.PACKAGE_STRATEGY_AUTOBUDGET_RESTART_MIGRATION_RELAX_TIME,
            PpcPropertyNames.SHOW_REFLECTED_ATTRS_FOR_ALL_MOBILE_BANNERS,
            PpcPropertyNames.SHOW_REFLECTED_ATTRS_FOR_ALL_MOBILE_BANNERS_FOR_CLIENTS,
            PpcPropertyNames.UC_UPDATE_CAMPAIGN_TARGET_STATUS_IDLE_TIME,
            PpcPropertyNames.MIN_PHONE_VERIFICATION_COOLDOWN_HOURS,

            // retargeting condition shortcuts
            PpcPropertyNames.RETARGETING_CONDITION_CAMPAIGN_GOALS_SHORTCUT_GOAL_TIME_DAYS,
            PpcPropertyNames.RETARGETING_CONDITION_CAMPAIGN_GOALS_LAL_SHORTCUT_GOAL_TIME_DAYS,

            // Offer preview requesting
            PpcPropertyNames.UPDATE_OFFERS_PREVIEW_JOB_ENABLED,
            PpcPropertyNames.UPDATE_OFFERS_PREVIEW_SLEEP_COEF,
            PpcPropertyNames.UPDATE_OFFERS_PREVIEW_SENDING_CHUNK_SIZE,
            PpcPropertyNames.OFFERS_PREVIEW_EXPIRATION_HOURS,

            PpcPropertyNames.DO_VALIDATE_FEED_SITES_BY_ECOM_DOMAINS,
            PpcPropertyNames.MIN_OFFERS_AMOUNT_ON_SITE_ALLOWED,
            PpcPropertyNames.MAX_OFFERS_AMOUNT_ON_SITE_ALLOWED,
            PpcPropertyNames.UAC_MODERATING_STATUS_FOR_ASSETS_WITHOUT_BANNERS,
            PpcPropertyNames.UAC_FAILED_JOBS_MONITORING_ENABLED,
            PpcPropertyNames.UAC_FAILED_JOBS_MONITORING_LAST_TIME,
            PpcPropertyNames.UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN,
            PpcPropertyNames.CPM_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN,
            PpcPropertyNames.ECOM_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN,
            PpcPropertyNames.MOBILE_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN,
            PpcPropertyNames.MYSQL2GRUT_ONESHOT_CHUNK_SIZE,
            PpcPropertyNames.MYSQL2GRUT_ONESHOT_RELAX_TIME_SEC,
            PpcPropertyNames.MINUSGEO_FLAGS_ONESHOT_CHUNK_SIZE,
            PpcPropertyNames.MINUSGEO_FLAGS_ONESHOT_RELAX_TIME_SEC,
            PpcPropertyNames.CAMPAIGN_REPLICATION_FILTER_WITHOUT_FOREIGN,
            PpcPropertyNames.ADGROUP_REPLICATION_FILTER_WITHOUT_FOREIGN,
            PpcPropertyNames.ENABLE_CREATE_EARLY_CREATIVE_IN_API,
            PpcPropertyNames.IGNORE_AUTOBUDGET_RESTART,
            PpcPropertyNames.BUSINESS_UNIT_CLIENT_IDS,

            PpcPropertyNames.INACCURACY_IN_PERCENTS_FOR_PROPORTIONALLY_LARGER_IMAGES,
            PpcPropertyNames.MAX_RATIO_FOR_PROPORTIONALLY_LARGER_IMAGES,

            PpcPropertyNames.IGNORE_MINUS_GEO_IN_ADGROUP_CONDITIONS_CID_PERCENT,
            PpcPropertyNames.IGNORE_MINUS_GEO_IN_ADGROUP_CONDITIONS_CIDS,
            PpcPropertyNames.UPDATE_SKAD_NETWORK_SLOTS_IN_GRUT,
            PpcPropertyNames.UPDATE_AUCTION_PRIORITY_IN_GRUT,

            //todo: возможно стоит подумать о том, чтобы автоматически привозить DIRECT-122600
            lastAbPreparedDate("HAHN---prepare_binlog_events.sql"),
            lastAbPreparedDate("HAHN---prepare_indexed_binlog_events.sql"),
            lastAbPreparedDate("HAHN---prepare_bs_stat_log.sql"),
            lastAbPreparedDate("HAHN---prepare_uaas_log.sql"),
            lastAbPreparedDate("HAHN---prepare_balance_log.sql"),
            lastAbPreparedDate("ARNOLD---prepare_binlog_events.sql"),
            lastAbPreparedDate("ARNOLD---prepare_indexed_binlog_events.sql"),
            lastAbPreparedDate("ARNOLD---prepare_bs_stat_log.sql"),
            lastAbPreparedDate("ARNOLD---prepare_uaas_log.sql"),
            lastAbPreparedDate("ARNOLD---prepare_balance_log.sql"),

            PpcPropertyNames.BRAND_SURVEY_BUDGET_DATE,
            PpcPropertyNames.USE_NEW_SELF_STATUS_CALCULATOR,
            PpcPropertyNames.USE_CLOUD_ADVQ_FORECAST,
            PpcPropertyNames.DELETE_UAC_ASSET_MIN_LOOKUP_TIME,
            PpcPropertyNames.DELETE_UAC_ASSET_CURRENT_DATE_OFFSET,
            PpcPropertyNames.DELETE_UAC_ASSET_IDLE_TIME,
            PpcPropertyNames.DELETE_UAC_ASSET_ITERATION_LIMIT,
            PpcPropertyNames.DELETE_UAC_ASSET_TOTAL_DELETE_LIMIT,
            PpcPropertyNames.UAC_GET_CAMPAIGN_PROTO_RESPONSE_DIFF_PERCENT,

            PpcPropertyNames.CRR_TRACKER_CONVERSIONS_NUM_THRESHOLD,
            PpcPropertyNames.CRR_MOBILE_APP_CONVERSIONS_NUM_THRESHOLD,
            PpcPropertyNames.CRR_CONVERSIONS_THRESHOLD_INTERVAL_IN_DAYS,

            PpcPropertyNames.CLEAN_TESTING_CAMPAIGNS_LOGINS,
            PpcPropertyNames.CLEAN_TESTING_CAMPAIGNS_CID_BLACKLIST,
            PpcPropertyNames.CLEAN_TESTING_CAMPAIGNS_AGE_MINUTES,

            PpcPropertyNames.APP_METRICA_REQUEST_LIMIT,
            PpcPropertyNames.APP_METRICA_REQUEST_IDLE_TIME,
            PpcPropertyNames.SEND_NEW_FEEDS_IN_BL_FROM_JOBS,

            PpcPropertyNames.MAX_TIME_DEPTH_FOR_AUTO_APPLY_HISTORY
    );

    private WebEditablePpcProperty() {
    }
}
