package ru.yandex.direct.core.entity.pricepackage.repository;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.type.TypeReference;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.core.entity.pricepackage.model.PriceMarkup;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackageCampaignOptions;
import ru.yandex.direct.core.entity.pricepackage.model.StatusApprove;
import ru.yandex.direct.core.entity.pricepackage.model.TargetingMarkup;
import ru.yandex.direct.core.entity.pricepackage.model.TargetingsCustom;
import ru.yandex.direct.core.entity.pricepackage.model.TargetingsFixed;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbschema.ppcdict.enums.CpmPricePackagesCurrency;
import ru.yandex.direct.dbschema.ppcdict.enums.CpmPricePackagesStatusApprove;
import ru.yandex.direct.utils.JsonUtils;

class PricePackageMapping {

    public static final TypeReference<Map<CreativeType, List<Long>>>
            ALLOWED_CREATIVE_TEMPLATES_TYPE_REFERENCE = new TypeReference<>() {
    };

    static String priceMarkupsToDbFormat(List<PriceMarkup> priceMarkups) {
        return JsonUtils.toJsonCollectionEmptyToNull(priceMarkups);
    }

    static List<PriceMarkup> priceMarkupsFromDbFormat(String json) {
        return json == null ? null : Arrays.asList(JsonUtils.fromJson(json, PriceMarkup[].class));
    }

    static String targetingsFixedToDbFormat(TargetingsFixed targetingsFixed) {
        return JsonUtils.toJson(targetingsFixed);
    }

    static TargetingsFixed targetingsFixedFromDbFormat(String json) {
        return JsonUtils.fromJson(json, TargetingsFixed.class);
    }

    static String targetingsCustomToDbFormat(TargetingsCustom targetingsCustom) {
        return JsonUtils.toJson(targetingsCustom);
    }

    static TargetingsCustom targetingsCustomFromDbFormat(String json) {
        return JsonUtils.fromJson(json, TargetingsCustom.class);
    }

    static String targetingMarkupsToDbFormat(List<TargetingMarkup> targetingMarkup) {
        return JsonUtils.toJsonCollectionEmptyToNull(targetingMarkup);
    }

    static List<TargetingMarkup> targetingMarkupsFromDbFormat(String json) {
        return json == null ? null : Arrays.asList(JsonUtils.fromJson(json, TargetingMarkup[].class));
    }

    static CpmPricePackagesCurrency currencyToDbFormat(CurrencyCode value) {
        return value == null ? null : CpmPricePackagesCurrency.valueOf(value.name());
    }

    static CurrencyCode currencyFromDbFormat(CpmPricePackagesCurrency value) {
        return value == null ? null : CurrencyCode.valueOf(value.name());
    }

    static CpmPricePackagesStatusApprove statusApproveToDbFormat(StatusApprove value) {
        return StatusApprove.toSource(value);
    }

    static StatusApprove statusApproveFromDbFormat(CpmPricePackagesStatusApprove value) {
        return StatusApprove.fromSource(value);
    }

    public static String allowedPageIdsToDbFormat(List<Long> allowedPageIds) {
        return allowedPageIds == null ? null : JsonUtils.toJson(allowedPageIds);
    }

    public static List<Long> allowedPageIdsFromDbFormat(String json) {
        if (json == null) {
            return null;
        }
        return Arrays.asList(JsonUtils.fromJson(json, Long[].class));
    }

    public static String stringListToDbJsonFormat(List<String> list) {
        return list == null ? null : JsonUtils.toJson(list);
    }

    public static List<String> stringListFromDbJsonFormat(String json) {
        if (json == null) {
            return null;
        }
        return Arrays.asList(JsonUtils.fromJson(json, String[].class));
    }

    public static String availableAdGroupTypesToDbFormat(Set<AdGroupType> availableAdGroupTypes) {
        return availableAdGroupTypes == null ? null :
                String.join(",", StreamEx.of(availableAdGroupTypes).map(AdGroupType::toString));
    }

    public static Set<AdGroupType> availableAdGroupTypesFromDbFormat(String field) {
        if (field == null) {
            return null;
        }
        return StreamEx.split(field, ",")
                .map(String::trim)
                .remove(StringUtils::isEmpty)
                .map(value -> Enum.valueOf(AdGroupType.class, value.toUpperCase()))
                .collect(Collectors.toSet());
    }

    public static PricePackageCampaignOptions campaignOptionsFromDbFormat(String field) {
        return field == null ? null : JsonUtils.fromJson(field, PricePackageCampaignOptions.class);
    }

    public static String campaignOptionsToDbFormat(PricePackageCampaignOptions campaignOptions) {
        return campaignOptions == null ? null : JsonUtils.toJson(campaignOptions);
    }

    public static List<BidModifier> bidModifiersFromDbFormat(String json) {
        return (json == null) ? null : JsonUtils.fromJson(json, new TypeReference<>() {});
    }

    public static String bidModifiersToDbFormat(List<BidModifier> bidModifiers) {
        return bidModifiers == null ? null : JsonUtils.toJson(bidModifiers, new TypeReference<List<BidModifier>>() {});
    }

    public static String allowedCreativeTemplatesToDbFormat(
            Map<CreativeType, List<Long>> allowedCreativeTemplates) {
        return allowedCreativeTemplates == null ? null : JsonUtils.toJson(allowedCreativeTemplates);
    }

    public static Map<CreativeType, List<Long>> allowedCreativeTemplatesFromDbFormat(String json) {
        if (json == null) {
            return null;
        }
        return JsonUtils.fromJson(json, ALLOWED_CREATIVE_TEMPLATES_TYPE_REFERENCE);
    }
}
