package ru.yandex.direct.core.entity.pricepackage.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.core.entity.pricepackage.service.validation.PricePackageAddValidationService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.operation.Applicability;

@Component
public class PricePackageAddOperationFactory {
    private final PricePackageRepository repository;
    private final PricePackageAddValidationService validationService;
    private final PricePackageService pricePackageService;

    @Autowired
    public PricePackageAddOperationFactory(PricePackageRepository repository,
                                           PricePackageAddValidationService validationService,
                                           PricePackageService pricePackageService) {
        this.repository = repository;
        this.validationService = validationService;
        this.pricePackageService = pricePackageService;
    }

    public PricePackageAddOperation newInstance(Applicability applicability,
                                                List<PricePackage> models,
                                                User operator) {
        return new PricePackageAddOperation(applicability, models, repository, validationService,
                pricePackageService, operator);
    }
}
