package ru.yandex.direct.core.entity.pricepackage.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.core.entity.pricepackage.service.validation.PricePackageDeleteValidationService;
import ru.yandex.direct.core.grut.replication.GrutApiService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;

@Component
public class PricePackageDeleteOperationFactory {

    private final DslContextProvider dslContextProvider;
    private final PricePackageRepository pricePackageRepository;
    private final PricePackageDeleteValidationService pricePackageDeleteValidationService;
    private final GrutApiService grutApiService;
    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public PricePackageDeleteOperationFactory(DslContextProvider dslContextProvider,
                                              PricePackageRepository pricePackageRepository,
                                              PricePackageDeleteValidationService pricePackageDeleteValidationService,
                                              GrutApiService grutApiService,
                                              PpcPropertiesSupport ppcPropertiesSupport) {
        this.dslContextProvider = dslContextProvider;
        this.pricePackageRepository = pricePackageRepository;
        this.pricePackageDeleteValidationService = pricePackageDeleteValidationService;
        this.grutApiService = grutApiService;
        this.ppcPropertiesSupport = ppcPropertiesSupport;

    }

    public PricePackageDeleteOperation newInstance(Applicability applicability, List<Long> modelIds) {
        return new PricePackageDeleteOperation(applicability, modelIds, dslContextProvider, pricePackageRepository,
                pricePackageDeleteValidationService, grutApiService, ppcPropertiesSupport);
    }
}
