package ru.yandex.direct.core.entity.pricepackage.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.pricepackage.model.TargetingsWithGeo;
import ru.yandex.direct.core.util.GeoTreeConverter;

@ParametersAreNonnullByDefault
public class PricePackageGeoProcessor {

    private final GeoTreeConverter geoTreeConverter;

    PricePackageGeoProcessor(GeoTreeConverter geoTreeConverter) {
        this.geoTreeConverter = geoTreeConverter;
    }

    void expandGeo(@Nullable TargetingsWithGeo targetings) {
        if (targetings == null) {
            return;
        }
        var geo = targetings.getGeo();
        var geoType = targetings.getGeoType();
        if (geo == null || geoType == null) {
            targetings.withGeoExpanded(null);
        } else {
            targetings.withGeoExpanded(geoTreeConverter.expandGeo(geo, geoType));
        }
    }

}
