package ru.yandex.direct.core.entity.pricepackage.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.util.GeoTreeConverter;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;

@Component
public class PricePackageGeoTree {

    private final GeoTreeFactory geoTreeFactory;
    private final GeoTreeConverter geoTreeConverter;
    private final PricePackageGeoProcessor geoProcessor;

    @Autowired
    public PricePackageGeoTree(GeoTreeFactory geoTreeFactory) {
        this.geoTreeFactory = geoTreeFactory;
        this.geoTreeConverter = new GeoTreeConverter(geoTreeFactory.getRussianGeoTree());
        this.geoProcessor = new PricePackageGeoProcessor(geoTreeConverter);
    }

    public GeoTree getGeoTree() {
        return geoTreeFactory.getRussianGeoTree();
    }

    public GeoTreeConverter getGeoTreeConverter() {
        return geoTreeConverter;
    }

    public PricePackageGeoProcessor getGeoProcessor() {
        return geoProcessor;
    }
}
