package ru.yandex.direct.core.entity.pricepackage.service;

import java.time.LocalDateTime;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.core.entity.pricepackage.service.validation.PricePackageUpdateValidationService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.grut.replication.GrutApiService;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
public class PricePackageUpdateOperationFactory {

    private final DslContextProvider dslContextProvider;
    private final PricePackageRepository repository;
    private final PricePackageUpdateValidationService validationService;
    private final PricePackageService pricePackageService;
    private final CampaignRepository campaignRepository;
    private final GrutApiService grutApiService;
    private final ShardHelper shardHelper;
    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public PricePackageUpdateOperationFactory(DslContextProvider dslContextProvider,
                                              PricePackageRepository repository,
                                              PricePackageUpdateValidationService validationService,
                                              PricePackageService pricePackageService,
                                              CampaignRepository campaignRepository,
                                              GrutApiService grutApiService,
                                              PpcPropertiesSupport ppcPropertiesSupport,
                                              ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.repository = repository;
        this.validationService = validationService;
        this.pricePackageService = pricePackageService;
        this.campaignRepository = campaignRepository;
        this.grutApiService = grutApiService;
        this.shardHelper = shardHelper;
        this.ppcPropertiesSupport = ppcPropertiesSupport;
    }

    public PricePackageUpdateOperation newInstance(Applicability applicability,
                                                   List<ModelChanges<PricePackage>> modelChanges,
                                                   List<LocalDateTime> userTimestamps,
                                                   User operator) {
        return new PricePackageUpdateOperation(applicability, modelChanges, userTimestamps, dslContextProvider,
                validationService, repository, pricePackageService, campaignRepository, grutApiService, shardHelper, ppcPropertiesSupport, operator);
    }

}
