package ru.yandex.direct.core.entity.pricepackage.service.validation;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.validation.defects.MoneyDefects;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

@ParametersAreNonnullByDefault
public class AvailableCurrencyConstraint implements Constraint<CurrencyCode, Defect> {

    private final Set<CurrencyCode> availableCurrencies;

    private AvailableCurrencyConstraint(Set<CurrencyCode> availableCurrencies) {
        this.availableCurrencies = availableCurrencies;
    }

    public static AvailableCurrencyConstraint allExcept(CurrencyCode... unavailableCurrencies) {
        Set<CurrencyCode> values = EnumSet.allOf(CurrencyCode.class);
        values.removeAll(Arrays.asList(unavailableCurrencies));
        return new AvailableCurrencyConstraint(values);
    }

    @Override
    public Defect apply(CurrencyCode currencyCode) {
        if (availableCurrencies.contains(currencyCode)) {
            return null;
        }
        return MoneyDefects.unavailableCurrency(currencyCode, availableCurrencies);
    }

}
