package ru.yandex.direct.core.entity.pricepackage.service.validation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.isEmptyCollection;

/**
 * Выполняет проверки списка пакетов специфичные для операции добавления.
 */
@Service
public class PricePackageAddValidationService {

    private final PricePackageValidationService validationService;

    @Autowired
    public PricePackageAddValidationService(PricePackageValidationService validationService) {
        this.validationService = validationService;
    }

    public ValidationResult<List<PricePackage>, Defect> validatePricePackages(List<PricePackage> pricePackages,
                                                                              GeoTree geoTree, User operator) {
        return ListValidationBuilder.<PricePackage, Defect>of(pricePackages)
                .checkBy(pricePackages2 -> validationService.validatePricePackages(pricePackages2, geoTree, operator))
                .checkEachBy(this::validatePricePackage)
                .getResult();
    }

    private ValidationResult<PricePackage, Defect> validatePricePackage(PricePackage pricePackage) {
        var vb = ModelItemValidationBuilder.of(pricePackage);

        vb.item(PricePackage.CLIENTS)
                .check(isEmptyCollection());

        return vb.getResult();
    }

}
