package ru.yandex.direct.core.entity.pricepackage.service.validation;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.Region;
import ru.yandex.direct.validation.constraint.LongsConstraint;
import ru.yandex.direct.validation.result.Defect;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefects.geoIncorrectRegions;
import static ru.yandex.direct.utils.StringUtils.joinLongsToString;

/**
 * Сюда следует передавать только валидные регионы.
 * Т.е. регионы, которые прошли проверку
 * {@link ru.yandex.direct.core.entity.region.validation.RegionIdsValidator}
 */
@ParametersAreNonnullByDefault
public class PricePackageRegionsConstraint<T extends Collection<Long>> extends LongsConstraint<T> {

    public PricePackageRegionsConstraint(GeoTree geoTree, Integer maxGeoType) {
        super(regionId -> {
            // может прийти минус-регион
            regionId = Math.abs(regionId);
            Region region = geoTree.getRegion(regionId);
            checkNotNull(region, "PricePackageRegionsValidator should not be used for nonexistent regions");
            return region.getType() <= maxGeoType;
        });
    }

    @Override
    protected Defect buildDefect(List<Long> incorrectRegions) {
        return geoIncorrectRegions(joinLongsToString(incorrectRegions));
    }

}
