package ru.yandex.direct.core.entity.pricepackage.service.validation.defects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.defect.params.DateTimeDefectParams;
import ru.yandex.direct.validation.result.DefectId;

@ParametersAreNonnullByDefault
public class PricePackageDefectIds {

    public enum Gen implements DefectId<Void> {
        CLIENT_CURRENCY_NOT_EQUALS_PACKAGE_CURRENCY,
        GEO_EXPANDED_IS_EMPTY,
        PRICE_PACKAGE_IS_EXPIRED,
        CRYPTA_TYPES_COUNT_IS_MISMATCHED,
        CREATIVE_TEMPLATES_IS_EMPTY,
        CREATIVE_TEMPLATES_AND_AD_GROUP_TYPES_MISMATCHED,
        MUTUAL_EXCLUSIVE_BID_MODIFIERS_SELECTED,
        DATE_START_CAN_ONLY_EXPAND,
        DATE_END_CAN_ONLY_EXPAND,
        CREATIVE_TEMPLATES_CAN_ONLY_EXPAND,
        RETARGETING_CATEGORIES_AMOUNT_LESS_LOWER_LIMIT,
        RETARGETING_CATEGORIES_AMOUNT_GREATER_UPPER_LIMIT,
        OVERLAPPING_PRICE_MARKUPS
    }

    public enum DateTime implements DefectId<DateTimeDefectParams> {
        USER_TIMESTAMP_NOT_EQUALS_LAST_UPDATE_TIME
    }

}
