package ru.yandex.direct.core.entity.pricepackage.service.validation.defects;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.defect.params.DateTimeDefectParams;
import ru.yandex.direct.validation.result.Defect;

@ParametersAreNonnullByDefault
public class PricePackageDefects {

    public static Defect<DateTimeDefectParams> userTimestampNotEqualsLastUpdateTime(LocalDateTime lastUpdateTime) {
        return new Defect<>(PricePackageDefectIds.DateTime.USER_TIMESTAMP_NOT_EQUALS_LAST_UPDATE_TIME,
                new DateTimeDefectParams().withExpectedValue(lastUpdateTime));
    }

    public static Defect<Void> mutualExcusiveModifiersSelected() {
        return new Defect<>(PricePackageDefectIds.Gen.MUTUAL_EXCLUSIVE_BID_MODIFIERS_SELECTED);
    }

    public static Defect<Void> clientCurrencyNotEqualsPackageCurrency() {
        return new Defect<>(PricePackageDefectIds.Gen.CLIENT_CURRENCY_NOT_EQUALS_PACKAGE_CURRENCY);
    }

    public static Defect<Void> geoExpandedIsEmpty() {
        return new Defect<>(PricePackageDefectIds.Gen.GEO_EXPANDED_IS_EMPTY);
    }

    public static Defect<Void> pricePackageIsExpired() {
        return new Defect<>(PricePackageDefectIds.Gen.PRICE_PACKAGE_IS_EXPIRED);
    }

    public static Defect<Void> cryptaTypesCountIsMismatched() {
        return new Defect<>(PricePackageDefectIds.Gen.CRYPTA_TYPES_COUNT_IS_MISMATCHED);
    }

    public static Defect<Void> creativeTemplatesIsEmpty() {
        return new Defect<>(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_IS_EMPTY);
    }

    public static Defect<Void> creativeTemplatesAndAdGroupTypesMismatched() {
        return new Defect<>(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_AND_AD_GROUP_TYPES_MISMATCHED);
    }

    public static Defect<Void> dateStartCanOnlyExpand() {
        return new Defect<>(PricePackageDefectIds.Gen.DATE_START_CAN_ONLY_EXPAND);
    }

    public static Defect<Void> dateEndCanOnlyExpand() {
        return new Defect<>(PricePackageDefectIds.Gen.DATE_END_CAN_ONLY_EXPAND);
    }

    public static Defect<Void> creativeTemplatesCanOnlyExpand() {
        return new Defect<>(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_CAN_ONLY_EXPAND);
    }

    public static Defect<Void> retargetingCategoriesAmountLessLowerLimit() {
        return new Defect<>(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_LESS_LOWER_LIMIT);
    }

    public static Defect<Void> retargetingCategoriesAmountGreaterUpperLimit() {
        return new Defect<>(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_GREATER_UPPER_LIMIT);
    }

    public static Defect<Void> overlappingPriceMarkups() {
        return new Defect<>(PricePackageDefectIds.Gen.OVERLAPPING_PRICE_MARKUPS);
    }
}
