package ru.yandex.direct.core.entity.product.repository;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbschema.ppcdict.enums.ProductsCurrency;

public class ProductMapping {
    private ProductMapping() {
    }

    public static ProductsCurrency currencyToDb(CurrencyCode currencyCode) {
        return currencyCode != null ?
                ProductsCurrency.valueOf(currencyCode.name()) : null;
    }

    public static CurrencyCode currencyFromDb(ProductsCurrency currency) {
        return currency != null ?
                CurrencyCode.valueOf(currency.name()) : null;
    }
}
