package ru.yandex.direct.core.entity.promocodes.model;

public enum TearOffReason {
    UNIT_TESTING(),
    CAMPAIGN_CHANGES(),
    ANTIVIR_ANALYTICS(),
    BAD_DOMIAN("multiple domains or unacceptable domain"),
    MISMATCH("domain or client does not match"),
    HAS_IMPRESSIONS("has impressions");

    private final String reason;
    private final boolean customName;

    TearOffReason() {
        this.reason = this.name().toLowerCase();
        customName = false;
    }

    TearOffReason(String reason) {
        this.reason = reason;
        customName = true;
    }

    @Override
    public String toString() {
        if (customName) {
            return String.format("%s (%s)", name(), reason);
        }
        return reason;
    }
}
