package ru.yandex.direct.core.entity.promocodes.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class PromocodeValidationContainer {
    private final ClientId clientId;
    private final String domain;
    private final boolean isClientConsideredNew;
    private final int domainsCount;

    public PromocodeValidationContainer(
            ClientId clientId,
            @Nullable String domain,
            boolean isClientConsideredNew,
            int domainsCount) {
        this.clientId = clientId;
        this.domain = domain;
        this.isClientConsideredNew = isClientConsideredNew;
        this.domainsCount = domainsCount;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public String getDomain() {
        return domain;
    }

    public boolean hasDomain() {
        return domain != null;
    }

    /**
     * Можно ли клиента считать новым для целей проверки флагов промокода.
     * Если у клиента нет домена, не нужно задаваться этим вопросом.
     * @return можно или точно нельзя.
     */
    public boolean isClientConsideredNew() {
        return isClientConsideredNew;
    }

    public int getDomainsCount() {
        return domainsCount;
    }
}
