package ru.yandex.direct.core.entity.region;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectTranslations;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.regions.Region;

import static java.util.Collections.singleton;
import static ru.yandex.direct.regions.Region.ASIA_REGION_ID;
import static ru.yandex.direct.regions.Region.BY_REGION_ID;
import static ru.yandex.direct.regions.Region.CRIMEA_REGION_ID;
import static ru.yandex.direct.regions.Region.KAZAKHSTAN_REGION_ID;
import static ru.yandex.direct.regions.Region.TURKEY_REGION_ID;
import static ru.yandex.direct.regions.Region.UKRAINE_REGION_ID;
import static ru.yandex.direct.regions.Region.UZBEKISTAN_REGION_ID;

public class RegionConstants {
    /**
     * Соответствие языков регионам. Перечисленные языки разрешены только в указанных регионах.
     * Если язык отсутствует в списке, значит ограничений на использование нет.
     * <p>
     * На украинском языке можно размещать объявления на Украине и в Крыму, независимо от принадлежности Крыма
     */
    public static final Map<Language, AllowedRegionsForLanguageContainer> LANGUAGE_TO_ALLOWED_REGIONS_CONTAINER =
            ImmutableMap.copyOf(Map.of(
            Language.UKRAINIAN, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(ImmutableSet.of(UKRAINE_REGION_ID, CRIMEA_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoUkraineDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithUkrainianLanguage(bannerId))
                    .build(),
            Language.KAZAKH, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(singleton(KAZAKHSTAN_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoKazahksanDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithKazakhLanguage(bannerId))
                    .build(),
            Language.TURKISH, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(singleton(TURKEY_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoTurkeyDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithTurkishLanguage(bannerId))
                    .build(),
            Language.BELARUSIAN, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(singleton(BY_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoBelarusDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithBelarussianLanguage(bannerId))
                    .build(),
            Language.UZBEK, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(singleton(UZBEKISTAN_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoUzbekDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithUzbekLanguage(bannerId))
                    .build(),
            Language.VIE, AllowedRegionsForLanguageContainer.builder()
                    .withAllowedRegionIds(singleton(ASIA_REGION_ID))
                    .withBannerDefectMessage(bannerDefectTranslations().inconsistentLanguageWithGeoVieDetailed())
                    .withAdGroupDefectMessageGetter(bannerId ->
                            adGroupDefectTranslations().badGeoDetailedInconsistentGeoWithVieLanguage(bannerId))
                    .build()
    ));

    private static BannerDefectTranslations bannerDefectTranslations() {
        return BannerDefectTranslations.INSTANCE;
    }

    private static AdGroupDefectTranslations adGroupDefectTranslations() {
        return AdGroupDefectTranslations.INSTANCE;
    }

    /**
     * Страны, где разрешена помощь при создании первой кампании
     */
    public static final Set<Long> FIRST_CAMPAIGN_HELP_COUNTRIES = Set.of(Region.RUSSIA_REGION_ID,
            Region.BY_REGION_ID, Region.KAZAKHSTAN_REGION_ID, Region.UZBEKISTAN_REGION_ID);
}
