package ru.yandex.direct.core.entity.region;

import ru.yandex.direct.regions.Region;

/**
 * Упрощенное представление региона, в отличие от {@link Region} не имеющее
 * циклических зависимостей, что позволяет делать сериализацию.
 */
public class RegionDesc {
    private final long id;
    private final String nameRu;
    private final String nameEn;
    private final String nameUa;
    private final String nameTr;

    private RegionDesc(long id, String nameRu, String nameEn, String nameUa, String nameTr) {
        this.id = id;
        this.nameRu = nameRu;
        this.nameEn = nameEn;
        this.nameUa = nameUa;
        this.nameTr = nameTr;
    }

    public static RegionDesc fromRegion(Region region) {
        return new RegionDesc(region.getId(), region.getNameRu(), region.getNameEn(),
                region.getNameUa(), region.getNameTr());
    }

    public long getId() {
        return id;
    }

    public String getNameRu() {
        return nameRu;
    }

    public String getNameEn() {
        return nameEn;
    }

    public String getNameUa() {
        return nameUa;
    }

    public String getNameTr() {
        return nameTr;
    }
}
