package ru.yandex.direct.core.entity.region;

import java.util.Map;
import java.util.function.Function;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Представление название региона как переводимой строки с интерфейсом {@link Translatable} для использования
 * в системе локализации Директа.
 */
public class TranslatableRegion implements Translatable {
    public static final Map<Language, Function<RegionDesc, String>> LOCALE_NAMES_GETTERS = ImmutableMap.of(
            Language.RU, RegionDesc::getNameRu,
            Language.EN, RegionDesc::getNameEn,
            Language.TR, RegionDesc::getNameTr,
            Language.UK, RegionDesc::getNameUa
    );
    private static final Function<RegionDesc, String> DEFAULT_NAMES_GETTER = RegionDesc::getNameRu;

    private final RegionDesc region;

    public TranslatableRegion(RegionDesc region) {
        this.region = region;
    }

    @Override
    public String translate(Translator translator) {
        Language language = Language.fromLocale(translator.getLocale());
        Function<RegionDesc, String> nameGetter = LOCALE_NAMES_GETTERS.get(language);
        checkNotNull(nameGetter, "Unsupported language");
        return nameGetter.apply(region);
    }
}
