package ru.yandex.direct.core.entity.region.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.GEO_REGIONS;

@Repository
@ParametersAreNonnullByDefault
public class RegionRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public RegionRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Long getParent(Long regionId) {
        List<Long> result =  dslContextProvider.ppcdict()
                .select(GEO_REGIONS.PARENT_ID)
                .from(GEO_REGIONS)
                .where(GEO_REGIONS.REGION_ID.eq(regionId))
                .fetch(GEO_REGIONS.PARENT_ID);
        return result.isEmpty() ? null : result.get(0);
    }
}
