package ru.yandex.direct.core.entity.region.validation;

import java.util.List;
import java.util.Objects;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.region.RegionDesc;
import ru.yandex.direct.core.entity.region.TranslatableRegion;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.types.ConcatTranslatable;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class RegionDefectParams {
    private final List<RegionDesc> regions;

    public RegionDefectParams(List<RegionDesc> regions) {
        this.regions = regions;
    }

    public List<RegionDesc> getRegions() {
        return regions;
    }

    public Translatable toTranslatable() {
        return new ConcatTranslatable(", ", mapList(regions, TranslatableRegion::new));
    }

    public String toIdsString() {
        return StreamEx.of(regions).map(RegionDesc::getId).map(Object::toString).joining(", ");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegionDefectParams that = (RegionDefectParams) o;
        return Objects.equals(toIdsString(), that.toIdsString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(toIdsString());
    }

    @Override
    public String toString() {
        return "RegionDefectParams{regions=" + toIdsString() + '}';
    }
}
