package ru.yandex.direct.core.entity.region.validation;

import java.util.List;

import ru.yandex.direct.core.entity.region.RegionDesc;
import ru.yandex.direct.regions.Region;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class RegionIdDefects {

    public static Defect geoEmptyRegions() {
        return new Defect<>(RegionIdDefectIds.Gen.EMPTY_REGIONS);
    }

    public static Defect geoIncorrectUseOfZeroRegion() {
        return new Defect<>(RegionIdDefectIds.Gen.INCORRECT_USE_OF_ZERO_REGION);
    }

    public static Defect geoIncorrectRegions(String regionIds) {
        return new Defect<>(RegionIdDefectIds.RegionIds.INCORRECT_REGIONS,
                new RegionIdsDefectParams().withRegionIds(regionIds));
    }

    public static Defect geoMinusRegionMatchesPlusRegion(String minusRegionIds, String plusRegionIds) {
        return new Defect<>(RegionIdDefectIds.RegionIds.MINUS_REGION_MATCHES_PLUS_REGION,
                new RegionIdsDefectParams().withRegionIds(plusRegionIds).withMinusRegionIds(minusRegionIds));
    }

    public static Defect geoNonUniqueRegions(List<Region> regions) {
        return new Defect<>(RegionIdDefectIds.Regions.NON_UNIQUE_REGIONS,
                new RegionDefectParams(mapList(regions, RegionDesc::fromRegion)));
    }

    public static Defect geoNoPlusRegions() {
        return new Defect<>(RegionIdDefectIds.Gen.NO_PLUS_REGIONS);
    }

    public static Defect geoMinusRegionsWithoutPlusRegions(List<Region> regions) {
        return new Defect<>(RegionIdDefectIds.Regions.MINUS_REGIONS_WITHOUT_PLUS_REGIONS,
                new RegionDefectParams(mapList(regions, RegionDesc::fromRegion)));
    }

    public static Defect geoFrontpageNoDesktopImmersionsInRegions(List<Region> regions) {
        return new Defect<>(RegionIdDefectIds.Regions.GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE,
                new RegionDefectParams(mapList(regions, RegionDesc::fromRegion)));
    }

    public static Defect geoFrontpageNoMobileImmersionsInRegions(List<Region> regions) {
        return new Defect<>(RegionIdDefectIds.Regions.GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE,
                new RegionDefectParams(mapList(regions, RegionDesc::fromRegion)));
    }

    public static Defect geoFrontpageNoBrowserNewTabImmersionsInRegions(List<Region> regions) {
        return new Defect<>(RegionIdDefectIds.Regions.GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE,
                new RegionDefectParams(mapList(regions, RegionDesc::fromRegion)));
    }
}
