package ru.yandex.direct.core.entity.region.validation;

public class RegionIdsDefectParams {
    private String regionIds;
    private String minusRegionIds;

    public String getRegionIds() {
        return regionIds;
    }

    public RegionIdsDefectParams withRegionIds(String regionIds) {
        this.regionIds = regionIds;
        return this;
    }

    public String getMinusRegionIds() {
        return minusRegionIds;
    }

    public RegionIdsDefectParams withMinusRegionIds(String minusRegionIds) {
        this.minusRegionIds = minusRegionIds;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        RegionIdsDefectParams that = (RegionIdsDefectParams) o;

        if (regionIds != null ? !regionIds.equals(that.regionIds) : that.regionIds != null) {
            return false;
        }
        return minusRegionIds != null ? minusRegionIds.equals(that.minusRegionIds) : that.minusRegionIds == null;
    }

    @Override
    public int hashCode() {
        int result = regionIds != null ? regionIds.hashCode() : 0;
        result = 31 * result + (minusRegionIds != null ? minusRegionIds.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RegionIdsDefectParams{" +
                "regionIds='" + regionIds + '\'' +
                ", minusRegionIds='" + minusRegionIds + '\'' +
                '}';
    }
}
