package ru.yandex.direct.core.entity.relevancematch.container;

import java.util.Map;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.dbutil.model.ClientId;

public class RelevanceMatchAddContainer {
    // идентификатор пользователя, являющего инициатором операции
    private Long operatorUid;
    // идентификатор клиента, для которого выполняется операция
    private ClientId clientId;
    // кампании клиента по id
    private Map<Long, Campaign> campaignsByIds;
    // id кампаний по id групп, к которым добавляется бесфразный таргетинг
    private Map<Long, Long> campaignIdsByAdGroupIds;

    private RelevanceMatchAddContainer() {
    }

    public static RelevanceMatchAddContainer createRelevanceMatchAddOperationContainer(
            long operatorUid, ClientId clientId, Map<Long, Campaign> campaignsByIds,
            Map<Long, Long> campaignIdByAdGroupId) {
        return new RelevanceMatchAddContainer()
                .withOperatorUid(operatorUid)
                .withClientId(clientId)
                .withCampaignIdsByAdGroupIds(campaignIdByAdGroupId)
                .withCampaignsByIds(campaignsByIds);
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public RelevanceMatchAddContainer withOperatorUid(final Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public RelevanceMatchAddContainer withClientId(final ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    public Campaign getCampaignByAdGroupId(Long adGroupId) {
        Long campaignId = campaignIdsByAdGroupIds.get(adGroupId);
        return campaignId != null ? campaignsByIds.get(campaignId) : null;
    }

    public Map<Long, Campaign> getCampaignsByIds() {
        return campaignsByIds;
    }

    public RelevanceMatchAddContainer withCampaignsByIds(
            Map<Long, Campaign> campaignsByIds) {
        this.campaignsByIds = campaignsByIds;
        return this;
    }

    public Map<Long, Long> getCampaignIdsByAdGroupIds() {
        return campaignIdsByAdGroupIds;
    }

    public RelevanceMatchAddContainer withCampaignIdsByAdGroupIds(
            Map<Long, Long> campaignIdByAdGroupId) {
        this.campaignIdsByAdGroupIds = campaignIdByAdGroupId;
        return this;
    }
}
