package ru.yandex.direct.core.entity.relevancematch.container;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class RelevanceMatchAddOperationParams {
    private boolean adGroupsNonexistentOnPrepare;
    private boolean autoPrices;

    private RelevanceMatchAddOperationParams(boolean adGroupsNonexistentOnPrepare, boolean autoPrices) {
        this.adGroupsNonexistentOnPrepare = adGroupsNonexistentOnPrepare;
        this.autoPrices = autoPrices;
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * @return {@code true}, если группы еще нет в базе на момент добавления автотаргетинга
     */
    public boolean isAdGroupsNonexistentOnPrepare() {
        return adGroupsNonexistentOnPrepare;
    }

    /**
     * @return {@code true}, если для автотаргетинга нужно расчитать автоматические недостающие ставки
     */
    public boolean isAutoPrices() {
        return autoPrices;
    }

    public static class Builder {
        private Boolean adGroupsNonexistentOnPrepare;
        private Boolean autoPrices;

        /**
         * Группы не существует в базе на момент добавления автотаргетинга
         */
        public Builder withAdGroupsNonexistentOnPrepare(boolean adGroupsNonexistentOnPrepare) {
            this.adGroupsNonexistentOnPrepare = adGroupsNonexistentOnPrepare;
            return this;
        }

        /**
         * Для автотаргетинга нужно расчитать автоматические недостающие ставки.
         * см. описание класса {@link ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchAddOperation}
         */
        public Builder withAutoPrices(boolean autoPrices) {
            this.autoPrices = autoPrices;
            return this;
        }

        public RelevanceMatchAddOperationParams build() {
            checkNotNull(adGroupsNonexistentOnPrepare, "adGroupsNonexistentOnPrepare must be specified");
            checkNotNull(autoPrices, "autoPrices must be specified");
            return new RelevanceMatchAddOperationParams(adGroupsNonexistentOnPrepare, autoPrices);
        }
    }
}
