package ru.yandex.direct.core.entity.relevancematch.service;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.utils.math.MathUtils;

public class RelevanceMatchUtils {
    public static final double PERCENTILE = 0.3;

    public static BigDecimal calculatePrice(@Nonnull List<BigDecimal> phrasesPrices, @Nonnull Currency currency) {
        double price = MathUtils.calcQuantile(phrasesPrices, PERCENTILE);
        return currencyPriceRounding(price, currency);
    }

    private static BigDecimal currencyPriceRounding(Double price, Currency currency) {
        BigDecimal bigDecimalPrice = BigDecimal.valueOf(price);
        if (bigDecimalPrice.compareTo(currency.getMinPrice()) < 0) {
            bigDecimalPrice = currency.getMinPrice();
        }

        if (bigDecimalPrice.compareTo(currency.getMaxPrice()) > 0) {
            bigDecimalPrice = currency.getMaxPrice();
        }
        Money money = Money.valueOf(bigDecimalPrice, currency.getCode()).roundToAuctionStepUp();
        return money.bigDecimalValue();
    }

    /**
     * у переданного бесфразного таргетинга сбрасывает расширенные атрибуты
     */
    public static void resetExtendedAttributes(@Nonnull RelevanceMatch relevanceMatch) {
        relevanceMatch.setPriceContext(null);
    }

    /**
     * Признак доступности расширенного автотаргетинга для указанной кампании
     */
    public static boolean isExtendedRelevanceMatchAllowedForCampaign(@Nonnull Campaign campaign) {
        return campaign.getType() != CampaignType.PERFORMANCE;
    }
}
