package ru.yandex.direct.core.entity.relevancematch.valdiation;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchValidationService.MAX_RELEVANCE_MATCHES_IN_GROUP;

public class RelevanceMatchDefects {
    public static Defect<Void> relevanceMatchCantBeUsedInAutoBudgetCompany() {
        return new Defect<>(Gen.RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY);
    }

    public static Defect<Void> relevanceMatchCantBeUsedWhenSearchIsStopped() {
        return new Defect<>(Gen.RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY);
    }

    static Defect<Void> relevanceMatchAlreadyDeleted() {
        return new Defect<>(Gen.RELEVANCE_MATCH_ALREADY_DELETED);
    }

    public static Defect<Void> relevanceMatchAlreadySuspended() {
        return new Defect<>(Gen.RELEVANCE_MATCH_ALREADY_SUSPENDED);
    }

    public static Defect<Void> relevanceMatchNotSuspended() {
        return new Defect<>(Gen.RELEVANCE_MATCH_NOT_SUSPENDED);
    }

    static Defect<Void> relevanceMatchCantBeDeletedFromAdGroupWithoutPhrases() {
        return new Defect<>(Gen.RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES);
    }

    public static Defect maxRelevanceMatchesInAdGroup() {
        return new Defect<>(Number.TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP,
                new NumberDefectParams().withMax(MAX_RELEVANCE_MATCHES_IN_GROUP));
    }

    public enum Gen implements DefectId<Void> {
        RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY,
        RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED,
        RELEVANCE_MATCH_ALREADY_DELETED,
        RELEVANCE_MATCH_ALREADY_SUSPENDED,
        RELEVANCE_MATCH_NOT_SUSPENDED,
        RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES
    }

    public enum Number implements DefectId<NumberDefectParams> {
        TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP,
    }
}
