package ru.yandex.direct.core.entity.relevancematch.valdiation;

import java.util.function.BiPredicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;

@ParametersAreNonnullByDefault
public class RelevanceMatchPredicates {
    /**
     * проверка, что у автотаргетинга нет поисковой ставки, но она нужна
     * в стратегии.
     * Здесь есть странность в том, что поисковая ставка требуется даже если
     * в стратегии выключены показы на поиске. Почему так - см
     * https://st.yandex-team.ru/DIRECT-84979
     */
    public static final BiPredicate<RelevanceMatch, DbStrategy> RM_MISSING_SEARCH_PRICE = (rm, strategy) ->
            rm.getPrice() == null && strategy.isSearchManualBidManaging();
    /**
     * проверка, что у автотаргетинга нет ставки на сети, но она нужна
     * в стратегии.
     */
    public static final BiPredicate<RelevanceMatch, DbStrategy> RM_MISSING_CONTEXT_PRICE = (rm, strategy) ->
            rm.getPriceContext() == null && strategy.isContextManualBidManaging();
    /**
     * проверка, что у автотаргетинга нет приоритета автобюджета, но он нужен
     * в стратегии.
     */
    public static final BiPredicate<RelevanceMatch, DbStrategy> RM_MISSING_AUTOBUDGET_PRIORITY = (rm, strategy) ->
            rm.getAutobudgetPriority() == null && strategy.isAutoBudget();
}
