package ru.yandex.direct.core.entity.retargeting.container;

import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;


public class ReplaceRetargetingConditionGoal implements Model {
    public static final ModelProperty<ReplaceRetargetingConditionGoal, Long> NEW_GOAL_ID =
            prop("newGoalId", ReplaceRetargetingConditionGoal::getNewGoalId,
                    ReplaceRetargetingConditionGoal::setNewGoalId);

    public static final ModelProperty<ReplaceRetargetingConditionGoal, Long> OLD_GOAL_ID =
            prop("oldGoalId", ReplaceRetargetingConditionGoal::getOldGoalId,
                    ReplaceRetargetingConditionGoal::setOldGoalId);

    private static <V> ModelProperty<ReplaceRetargetingConditionGoal, V> prop(String name,
                                                                              Function<ReplaceRetargetingConditionGoal, V> getter, BiConsumer<ReplaceRetargetingConditionGoal, V> setter) {
        return ModelProperty.create(ReplaceRetargetingConditionGoal.class, name, getter, setter);
    }

    private Long oldGoalId;

    private Long newGoalId;


    public Long getOldGoalId() {
        return oldGoalId;
    }

    public ReplaceRetargetingConditionGoal withOldGoalId(Long oldGoalId) {
        this.oldGoalId = oldGoalId;
        return this;
    }

    public void setOldGoalId(Long oldGoalId) {
        this.oldGoalId = oldGoalId;
    }

    public Long getNewGoalId() {
        return newGoalId;
    }

    public ReplaceRetargetingConditionGoal withNewGoalId(Long newGoalId) {
        this.newGoalId = newGoalId;
        return this;
    }

    public void setNewGoalId(Long newGoalId) {
        this.newGoalId = newGoalId;
    }
}
