package ru.yandex.direct.core.entity.retargeting.container;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.CpmYndxFrontpageAdGroupPriceRestrictions;

import static com.google.common.base.Preconditions.checkArgument;

public class RetargetingAdGroupInfo {
    private Long adGroupFakeId;
    private AdGroup adGroup;
    private Long campaignId;
    private CampaignType campaignType;
    private CpmYndxFrontpageAdGroupPriceRestrictions cpmYndxFrontpagePriceRestrictions;

    public RetargetingAdGroupInfo(Long adGroupFakeId, AdGroup adGroup, Long campaignId, CampaignType campaignType,
                                  CpmYndxFrontpageAdGroupPriceRestrictions cpmYndxFrontpagePriceRestrictions) {
        checkArgument(adGroupFakeId != null, "ad group index shouldn't be null");
        checkArgument(adGroup != null, "ad group shouldn't be null");
        checkArgument(campaignId != null, "campaign id shouldn't be null");
        checkArgument(campaignType == CampaignType.CPM_PRICE || adGroup.getType() != AdGroupType.CPM_YNDX_FRONTPAGE || cpmYndxFrontpagePriceRestrictions != null,
                "currency info shouldn't be null for frontpage adgroups");
        this.adGroupFakeId = adGroupFakeId;
        this.adGroup = adGroup;
        this.campaignId = campaignId;
        this.campaignType = campaignType;
        this.cpmYndxFrontpagePriceRestrictions = cpmYndxFrontpagePriceRestrictions;
    }

    public Long getAdGroupFakeId() {
        return adGroupFakeId;
    }

    public AdGroup getAdGroup() {
        return adGroup;
    }

    public AdGroupType getAdGroupType() {
        return adGroup.getType();
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public CpmYndxFrontpageAdGroupPriceRestrictions getCpmYndxFrontpageAdGroupPriceRestrictions() {
        return cpmYndxFrontpagePriceRestrictions;
    }
}
