package ru.yandex.direct.core.entity.retargeting.container;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;


public class RetargetingSelection implements Model {
    public static final ModelProperty<RetargetingSelection, List<Long>> IDS =
            prop("ids", RetargetingSelection::getIds, RetargetingSelection::setIds);
    public static final ModelProperty<RetargetingSelection, List<Long>> ADGROUP_IDS =
            prop("adGroupIds", RetargetingSelection::getAdGroupIds, RetargetingSelection::setAdGroupIds);
    public static final ModelProperty<RetargetingSelection, List<Long>> CAMPAIGN_IDS =
            prop("campaignIds", RetargetingSelection::getCampaignIds, RetargetingSelection::setCampaignIds);
    public static final ModelProperty<RetargetingSelection, List<Long>> RETARGETING_LIST_IDS =
            prop("retargetingListIds", RetargetingSelection::getRetargetingListIds,
                    RetargetingSelection::setRetargetingListIds);
    public static final ModelProperty<RetargetingSelection, List<Long>> INTEREST_IDS =
            prop("interestIds", RetargetingSelection::getInterestIds, RetargetingSelection::setInterestIds);

    private static <V> ModelProperty<RetargetingSelection, V> prop(String name,
                                                                   Function<RetargetingSelection, V> getter, BiConsumer<RetargetingSelection, V> setter) {
        return ModelProperty.create(RetargetingSelection.class, name, getter, setter);
    }

    private List<Long> ids;

    private List<Long> adGroupIds;

    private List<Long> campaignIds;

    private List<Long> retargetingListIds;

    private List<Long> interestIds;

    private Boolean isSuspended;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public List<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public void setAdGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }

    public List<Long> getCampaignIds() {
        return campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public List<Long> getRetargetingListIds() {
        return retargetingListIds;
    }

    public void setRetargetingListIds(List<Long> retargetingListIds) {
        this.retargetingListIds = retargetingListIds;
    }

    public List<Long> getInterestIds() {
        return interestIds;
    }

    public void setInterestIds(List<Long> interestIds) {
        this.interestIds = interestIds;
    }

    public Boolean getSuspended() {
        return isSuspended;
    }

    public void setSuspended(Boolean suspended) {
        isSuspended = suspended;
    }

    public RetargetingSelection withIds(List<Long> ids) {
        this.ids = ids;
        return this;
    }

    public RetargetingSelection withAdGroupIds(final List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public RetargetingSelection withCampaignIds(final List<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public RetargetingSelection withRetargetingListIds(final List<Long> retargetingListIds) {
        this.retargetingListIds = retargetingListIds;
        return this;
    }

    public RetargetingSelection withInterestIds(final List<Long> interestIds) {
        this.interestIds = interestIds;
        return this;
    }

    public RetargetingSelection withIsSuspended(final Boolean isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }

    public boolean isEmpty() {
        return ids.isEmpty() && adGroupIds.isEmpty() && campaignIds.isEmpty();
    }
}
