package ru.yandex.direct.core.entity.retargeting.container;

import java.util.Collections;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbschema.ppc.enums.RetargetingConditionsRetargetingConditionsType;

@ParametersAreNonnullByDefault
public class RetargetingSelectionCriteria {

    private Set<Long> ids;
    private Set<RetargetingConditionsRetargetingConditionsType> types;

    @Nullable
    public Set<Long> getIds() {
        return ids;
    }

    public void setIds(@Nullable Set<Long> ids) {
        this.ids = ids;
    }

    public RetargetingSelectionCriteria withIds(@Nullable Set<Long> retargetingIds) {
        this.ids = retargetingIds;
        return this;
    }

    @Nonnull
    public Set<RetargetingConditionsRetargetingConditionsType> getTypes() {
        return types == null ? Collections.emptySet() : types;
    }

    public void setTypes(Set<RetargetingConditionsRetargetingConditionsType> types) {
        this.types = types;
    }

    public RetargetingSelectionCriteria withTypes(@Nullable Set<RetargetingConditionsRetargetingConditionsType> types) {
        this.types = types;
        return this;
    }
}
