package ru.yandex.direct.core.entity.retargeting.container;

import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;


public final class SwitchRetargeting implements Model {

    public static final ModelProperty<SwitchRetargeting, Long> RET_COND_ID =
            prop("retCondId", SwitchRetargeting::getRetCondId, SwitchRetargeting::setRetCondId);
    public static final ModelProperty<SwitchRetargeting, Boolean> IS_SUSPENDED =
            prop("suspended", SwitchRetargeting::getSuspended, SwitchRetargeting::setSuspended);

    private static <V> ModelProperty<SwitchRetargeting, V> prop(String name,
                                                                Function<SwitchRetargeting, V> getter, BiConsumer<SwitchRetargeting, V> setter) {
        return ModelProperty.create(SwitchRetargeting.class, name, getter, setter);
    }

    private Long retCondId;
    private Boolean suspended;


    public SwitchRetargeting withRetCondId(Long retCondId) {

        this.retCondId = retCondId;
        return this;
    }

    public Long getRetCondId() {
        return retCondId;
    }


    public void setRetCondId(Long retCondId) {
        this.retCondId = retCondId;
    }

    public SwitchRetargeting withSuspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }


    public Boolean getSuspended() {
        return suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

}
