package ru.yandex.direct.core.entity.retargeting.converter;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.MetrikaCounterGoalType;
import ru.yandex.direct.core.entity.retargeting.service.common.GoalUtilsService;
import ru.yandex.direct.metrika.client.model.request.RetargetingGoal;
import ru.yandex.direct.metrika.client.model.response.CounterGoal;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class GoalConverter {
    private GoalConverter() {
    }

    public static List<Goal> fromCounterGoals(Collection<CounterGoal> counterGoal) {
        return mapList(counterGoal, GoalConverter::fromCounterGoal);
    }

    public static Goal fromCounterGoal(CounterGoal counterGoal) {
        Goal goal = new Goal();
        goal.withId((long) counterGoal.getId())
                .withName(counterGoal.getName())
                .withParentId(counterGoal.getParentId())
                .withMetrikaCounterGoalType(fromMetrikaGoalType(counterGoal.getType()))
                .withDefaultPrice(counterGoal.getDefaultPrice())
                .withAllowToUse(true);
        return GoalUtilsService.changeEcommerceGoalName(goal);
    }

    public static Goal fromMetrikaRetargetingCondition(RetargetingCondition retargetingCondition) {
        Goal goal = new Goal();
        goal.withId(retargetingCondition.getId())
                .withType(GoalTypeConverter.fromSource(retargetingCondition.getType()))
                .withAllowToUse(true)
                .withOwner(retargetingCondition.getOwner())
                .withCounterId(retargetingCondition.getCounterId())
                .withCounterIds(retargetingCondition.getCounterIds())
                .withCounterName(retargetingCondition.getCounterName())
                .withDomain(retargetingCondition.getCounterDomain())
                .withSubtype(retargetingCondition.getGoalSubtype())
                .withName(retargetingCondition.getName())
                .withSectionId(retargetingCondition.getSectionId())
                .withUploadingSourceId(retargetingCondition.getUploadingSourceId())
                .withPercent(retargetingCondition.getPercent())
                .withSectionName(retargetingCondition.getSectionName());

        return GoalUtilsService.changeEcommerceGoalName(goal);
    }

    public static MetrikaCounterGoalType fromMetrikaGoalType(CounterGoal.Type value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case URL:
                return MetrikaCounterGoalType.URL;
            case NUMBER:
                return MetrikaCounterGoalType.NUMBER;
            case STEP:
                return MetrikaCounterGoalType.STEP;
            case ACTION:
                return MetrikaCounterGoalType.ACTION;
            case OFFLINE:
                return MetrikaCounterGoalType.OFFLINE;
            case CALL:
                return MetrikaCounterGoalType.CALL;
            case PHONE:
                return MetrikaCounterGoalType.PHONE;
            case EMAIL:
                return MetrikaCounterGoalType.EMAIL;
            case FORM:
                return MetrikaCounterGoalType.FORM;
            case CDP_ORDER_IN_PROGRESS:
                return MetrikaCounterGoalType.CDP_ORDER_IN_PROGRESS;
            case CDP_ORDER_PAID:
                return MetrikaCounterGoalType.CDP_ORDER_PAID;
            case MESSENGER:
                return MetrikaCounterGoalType.MESSENGER;
            case FILE:
                return MetrikaCounterGoalType.FILE;
            case SEARCH:
                return MetrikaCounterGoalType.SEARCH;
            case BUTTON:
                return MetrikaCounterGoalType.BUTTON;
            case E_CART:
                return MetrikaCounterGoalType.E_CART;
            case E_PURCHASE:
                return MetrikaCounterGoalType.E_PURCHASE;
            case A_CART:
                return MetrikaCounterGoalType.A_CART;
            case A_PURCHASE:
                return MetrikaCounterGoalType.A_PURCHASE;
            case CONDITIONAL_CALL:
                return MetrikaCounterGoalType.CONDITIONAL_CALL;
            case SOCIAL:
                return MetrikaCounterGoalType.SOCIAL;
            case PAYMENT_SYSTEM:
                return MetrikaCounterGoalType.PAYMENT_SYSTEM;
            case CONTACT_DATA:
                return MetrikaCounterGoalType.CONTACT_DATA;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @SuppressWarnings("WeakerAccess")
    public static RetargetingGoal toMetrikaGoal(Goal goal) {
        return new RetargetingGoal(goal.getId(), goal.getTime());
    }
}
