package ru.yandex.direct.core.entity.retargeting.converter;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.retargeting.model.GoalType;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;

public class GoalTypeConverter {
    @Nullable
    public static GoalType fromSource(RetargetingCondition.Type value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case GOAL:
                return GoalType.GOAL;
            case SEGMENT:
                return GoalType.SEGMENT;
            case AUDIENCE:
                return GoalType.AUDIENCE;
            case ECOMMERCE:
                return GoalType.ECOMMERCE;
            case AB_SEGMENT:
                return GoalType.AB_SEGMENT;
            case CDP_SEGMENT:
                return GoalType.CDP_SEGMENT;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static RetargetingCondition.Type toSource(GoalType value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case GOAL:
                return RetargetingCondition.Type.GOAL;
            case SEGMENT:
                return RetargetingCondition.Type.SEGMENT;
            case AUDIENCE:
                return RetargetingCondition.Type.AUDIENCE;
            case ECOMMERCE:
                return RetargetingCondition.Type.ECOMMERCE;
            case AB_SEGMENT:
                return RetargetingCondition.Type.AB_SEGMENT;
            case CDP_SEGMENT:
                return RetargetingCondition.Type.CDP_SEGMENT;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
