package ru.yandex.direct.core.entity.retargeting.converter;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.retargeting.model.RuleType;
import ru.yandex.direct.metrika.client.model.request.RetargetingGoalGroup;

public class RuleTypeConverter {
    @Nullable
    public static RuleType fromSource(RetargetingGoalGroup.Type value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case OR:
                return RuleType.OR;
            case ALL:
                return RuleType.ALL;
            case NOT:
                return RuleType.NOT;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static RetargetingGoalGroup.Type toSource(RuleType value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case OR:
                return RetargetingGoalGroup.Type.OR;
            case ALL:
                return RetargetingGoalGroup.Type.ALL;
            case NOT:
                return RetargetingGoalGroup.Type.NOT;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
