package ru.yandex.direct.core.entity.retargeting.model;

import java.util.List;

import com.google.common.collect.Iterables;

import static com.google.common.base.Preconditions.checkState;

/**
 * Класс добавляет абстракцию по работе с категорями нацеливания (интересами),
 * которые хранятся как {@link RetargetingCondition}'ы
 */
public class InterestLink {
    private final RetargetingCondition retargetingCondition;
    private final Long interestId;

    public InterestLink(RetargetingCondition retargetingCondition, Long interestId) {
        List<Goal> goals = retargetingCondition.collectGoals();
        checkState(retargetingCondition.getInterest(), "Given RetargetingCondition has no INTEREST property");
        checkState(goals.size() == 1,
                "Given RetargetingCondition with id %s has wrong amount of goals (%s). Can't be interest",
                retargetingCondition.getId(),
                goals.size());
        this.retargetingCondition = retargetingCondition;
        this.interestId = interestId;
    }

    public Long getInterestId() {
        return interestId;
    }

    public Long getGoalId() {
        // Проверки, что usedGoals содержит ровно один элемент -- в конструкторе.
        // Полагаем, что retCond не меняется после создания Interest
        return Iterables.getOnlyElement(retargetingCondition.collectGoals()).getId();
    }

    /**
     * @return соответствующий {@link RetargetingCondition} для сохранения в БД.
     * Свойство {@link RetargetingCondition#INTEREST} у получившегося объекта &ndash; {@code true}
     */
    public RetargetingCondition asRetargetingCondition() {
        return retargetingCondition;
    }

    /**
     * @return ID retargetingCondition'а для использования в {@link Retargeting}
     */
    public Long getRetargetingConditionId() {
        return retargetingCondition.getId();
    }
}
