package ru.yandex.direct.core.entity.retargeting.model;

import java.util.Collections;
import java.util.List;

import one.util.streamex.StreamEx;

import static ru.yandex.direct.core.entity.retargeting.model.ConditionType.metrika_goals;

public class RetargetingCondition extends RetargetingConditionBase {
    public static final ConditionType DEFAULT_TYPE = metrika_goals;
    public static final String DEFAULT_NAME_FOR_TYPES_WITHOUT_NAME = "";

    public List<Goal> collectGoals() {
        return StreamEx.of(this.getRules()).flatCollection(Rule::getGoals).toList();
    }

    public List<Goal> collectGoalsSafe() {
        var rules = this.getRules();
        if (rules == null) {
            return Collections.emptyList();
        }
        return StreamEx.of(rules).flatCollection(Rule::getGoals).nonNull().toList();
    }

    /**
     * Возвращает true, если все правила используют отрицание.
     * Если список пустой, возвращается false.
     */
    public static boolean calcNegativeByRules(List<Rule> rules) {
        return !rules.isEmpty() && rules.stream().allMatch(r -> r.getType() == RuleType.NOT);
    }

    public Boolean getNegative() {
        return calcNegativeByRules(getRules());
    }

    public Boolean getInterest() {
        if (super.getInterest() == null) {
            // трактуем отсутствие значения как false
            return false;
        }
        return super.getInterest();
    }
}
