package ru.yandex.direct.core.entity.retargeting.model;

import java.math.BigInteger;

/**
 * Объект представляет словарную сущность "Interest"
 */
public class TargetingCategory {
    private final Long targetingCategoryId;
    private final Long parentId;
    private final String name;
    private final String originalName;

    /**
     * ID категории в источнике, из которого она была получена (цели в Метрике для rmp_interest)
     */
    private final BigInteger importId;

    private final boolean available;

    public TargetingCategory(Long targetingCategoryId, Long parentId, String name, String originalName,
                             BigInteger importId, boolean available) {
        this.targetingCategoryId = targetingCategoryId;
        this.parentId = parentId;
        this.name = name;
        this.originalName = originalName;
        this.importId = importId;
        this.available = available;
    }

    public Long getTargetingCategoryId() {
        return targetingCategoryId;
    }

    public Long getParentId() {
        return parentId;
    }

    public String getName() {
        return name;
    }

    public String getOriginalName() {
        return originalName;
    }

    public BigInteger getImportId() {
        return importId;
    }

    public boolean isAvailable() {
        return available;
    }
}
