package ru.yandex.direct.core.entity.retargeting.repository;

import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.retargeting.model.ConditionType;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.dbschema.ppc.enums.RetargetingConditionsRetargetingConditionsType;

import static java.util.Arrays.asList;
import static ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition.calcNegativeByRules;
import static ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository.PROPERTY_AUTO_RETARGETING;
import static ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository.PROPERTY_INTEREST;
import static ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository.PROPERTY_NEGATIVE;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public final class RetargetingConditionMappings {
    private static final ObjectMapper objectMapper = createObjectMapper();

    private RetargetingConditionMappings() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS,
                MapperFeature.AUTO_DETECT_FIELDS,
                MapperFeature.AUTO_DETECT_GETTERS,
                MapperFeature.AUTO_DETECT_IS_GETTERS);
        return mapper;
    }


    public static String rulesToJson(List<Rule> rules) {
        try {
            return objectMapper.writeValueAsString(rules);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    public static List<Rule> rulesFromJson(String jsonRules) {
        return StreamEx.of(fromJson(jsonRules, Rule[].class)).toList();
    }


    public static RetargetingConditionsRetargetingConditionsType conditionTypeToDb(ConditionType conditionType) {
        return conditionType != null
                ? RetargetingConditionsRetargetingConditionsType.valueOf(conditionType.name()) : null;
    }

    public static ConditionType conditionTypeFromDb(RetargetingConditionsRetargetingConditionsType conditionsType) {
        return conditionsType != null ? ConditionType.valueOf(conditionsType.name()) : null;
    }

    public static Boolean interestFromDb(String interest) {
        return interest != null ? interest.contains(PROPERTY_INTEREST) : null;
    }

    public static Boolean autoRetargetingFromDb(String autoRetargeting) {
        return autoRetargeting != null ? autoRetargeting.contains(PROPERTY_AUTO_RETARGETING) : null;
    }

    public static String propertiesToDb(List<Rule> rules, Boolean interest, Boolean autoRetargeting) {
        return Joiner.on(",").skipNulls().join(asList(
                calcNegativeByRules(rules) ? PROPERTY_NEGATIVE : null,
                interest == Boolean.TRUE ? PROPERTY_INTEREST : null,
                autoRetargeting == Boolean.TRUE ? PROPERTY_AUTO_RETARGETING : null
        ));
    }
}
