package ru.yandex.direct.core.entity.retargeting.repository;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.tables.RetargetingConditions.RETARGETING_CONDITIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperties;

public class RetargetingConditionRepositoryMapperProvider {

    public static JooqMapperWithSupplier<RetargetingCondition> createRetargetingConditionMapper() {
        return JooqMapperWithSupplierBuilder.builder(RetargetingCondition::new)
                .map(property(RetargetingCondition.ID, RETARGETING_CONDITIONS.RET_COND_ID))
                .map(property(RetargetingCondition.NAME, RETARGETING_CONDITIONS.CONDITION_NAME))
                .map(convertibleProperty(RetargetingCondition.TYPE, RETARGETING_CONDITIONS.RETARGETING_CONDITIONS_TYPE,
                        RetargetingConditionMappings::conditionTypeFromDb,
                        RetargetingConditionMappings::conditionTypeToDb))
                .map(property(RetargetingCondition.CLIENT_ID, RETARGETING_CONDITIONS.CLIENT_ID))
                .map(property(RetargetingCondition.DESCRIPTION, RETARGETING_CONDITIONS.CONDITION_DESC))
                .map(property(RetargetingCondition.LAST_CHANGE_TIME, RETARGETING_CONDITIONS.MODTIME))
                .map(booleanProperty(RetargetingCondition.DELETED, RETARGETING_CONDITIONS.IS_DELETED))
                .map(convertibleProperty(RetargetingCondition.RULES, RETARGETING_CONDITIONS.CONDITION_JSON,
                        RetargetingConditionMappings::rulesFromJson,
                        RetargetingConditionMappings::rulesToJson))
                .readProperty(RetargetingCondition.INTEREST,
                        fromField(RETARGETING_CONDITIONS.PROPERTIES)
                                .by(RetargetingConditionMappings::interestFromDb))
                .readProperty(RetargetingCondition.AUTO_RETARGETING,
                        fromField(RETARGETING_CONDITIONS.PROPERTIES)
                                .by(RetargetingConditionMappings::autoRetargetingFromDb))
                .writeField(RETARGETING_CONDITIONS.PROPERTIES,
                        fromProperties(RetargetingCondition.RULES, RetargetingCondition.INTEREST,
                                RetargetingCondition.AUTO_RETARGETING)
                                .by(RetargetingConditionMappings::propertiesToDb))
                .build();
    }
}
