package ru.yandex.direct.core.entity.retargeting.repository;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.dbschema.ppc.enums.BidsRetargetingStatusbssynced;

import static org.apache.commons.lang3.StringUtils.capitalize;

public final class RetargetingMappings {
    private RetargetingMappings() {
    }

    public static BidsRetargetingStatusbssynced statusBsSyncedToDb(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ?
                BidsRetargetingStatusbssynced.valueOf(capitalize(statusBsSynced.name().toLowerCase())) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDb(BidsRetargetingStatusbssynced statusBsSynced) {
        return statusBsSynced != null ?
                StatusBsSynced.valueOf(statusBsSynced.name().toUpperCase()) : null;
    }

    public static BigDecimal priceToDbFormat(BigDecimal price) {
        return price == null ? BigDecimal.ZERO : price;
    }

    public static BigDecimal priceFromDbFormat(BigDecimal price) {
        return price == null || price.compareTo(BigDecimal.ZERO) == 0 ? null : price;
    }
}
